/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft;

import com.song.nuclear_craft.blocks.BlockList;
import com.song.nuclear_craft.blocks.container.ContainerTypeList;
import com.song.nuclear_craft.blocks.tileentity.TileEntityRegister;
import com.song.nuclear_craft.client.ClientSetup;
import com.song.nuclear_craft.effects.EffectRegister;
import com.song.nuclear_craft.entities.EntityRegister;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.misc.ConfigClient;
import com.song.nuclear_craft.misc.ConfigCommon;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.particles.BigSmokeParticle;
import com.song.nuclear_craft.particles.ExplodeCoreParticle;
import com.song.nuclear_craft.particles.ParticleRegister;
import com.song.nuclear_craft.particles.RestrictedSmokeParticle;
import com.song.nuclear_craft.particles.ShockWaveParticle;
import com.song.nuclear_craft.villagers.PointOfInterestTypes;
import com.song.nuclear_craft.villagers.ProfessionTypes;
import com.song.nuclear_craft.villagers.VillagerUtil;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nuclear_craft")
public class NuclearCraft {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "nuclear_craft";
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("weapons"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemList.ATOMIC_BOMB_ROCKET.get());
        }
    };
    public static final CreativeModeTab AMMO_ITEM_GROUP = new CreativeModeTab("bullets"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemList.AMMO_REGISTRIES_TYPE.get((Object)AmmoSize.SIZE_127).get((Object)AmmoType.NORMAL).get());
        }
    };

    public NuclearCraft() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        EntityRegister.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ParticleRegister.PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ItemList.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BlockList.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ProfessionTypes.VILLAGER_PROFESSION.register(FMLJavaModLoadingContext.get().getModEventBus());
        PointOfInterestTypes.POINT_OF_INTEREST_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        EffectRegister.EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TileEntityRegister.TILE_ENTITY_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigClient.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigCommon.COMMON);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.f_50493_.getRegistryName());
        VillagerUtil.fixPOITypeBlockStates((PoiType)PointOfInterestTypes.RIFLE_AMMO_SELLER.get());
        VillagerUtil.fixPOITypeBlockStates((PoiType)PointOfInterestTypes.SHOTGUN_AMMO_SELLER.get());
        VillagerUtil.fixPOITypeBlockStates((PoiType)PointOfInterestTypes.GUN_SELLER.get());
        VillagerUtil.fixPOITypeBlockStates((PoiType)PointOfInterestTypes.ROCKET_MASTER.get());
        VillagerUtil.fixPOITypeBlockStates((PoiType)PointOfInterestTypes.EXPLOSIVE_MASTER.get());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientSetup.clientSetup(event);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            LOGGER.info("HELLO from Register Block");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BlockList.C4_ATOMIC_BOMB, BlockList.C4_HIGH_EXPLOSIVE, BlockList.C4_INCENDIARY, BlockList.C4_SMOKE});
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            LOGGER.info("HELLO from Register Item");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ItemList.C4_ATOMIC_BOMB, ItemList.C4_HIGH_EXPLOSIVE, ItemList.C4_INCENDIARY, ItemList.C4_SMOKE});
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> event) {
        }

        @SubscribeEvent
        public static void onParticleRegistry(RegistryEvent.Register<ParticleType<?>> event) {
        }

        @SubscribeEvent
        public static void onParticleFactoryRegistry(ParticleFactoryRegisterEvent event) {
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegister.NUKE_PARTICLE_SMOKE.get(), BigSmokeParticle.NukeParticleFactory::new);
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegister.NUKE_PARTICLE_FIRE.get(), BigSmokeParticle.NukeParticleFactory::new);
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegister.BIG_SMOKE.get(), BigSmokeParticle.BigSmokeFactory::new);
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegister.RESTRICTED_HEIGHT_SMOKE_PARTICLE.get(), RestrictedSmokeParticle.RestrictedHeightFactory::new);
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegister.MUSHROOM_SMOKE_PARTICLE.get(), RestrictedSmokeParticle.MushroomFactory::new);
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegister.SHOCK_WAVE.get(), ShockWaveParticle.Factory::new);
            Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleRegister.EXPLODE_CORE.get(), ExplodeCoreParticle.Factory::new);
        }

        @SubscribeEvent
        public static void onContainerTypeRegistry(RegistryEvent.Register<MenuType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new MenuType[]{ContainerTypeList.C4_BOMB_CONTAINER_TYPE});
        }

        @SubscribeEvent
        public static void doBothStuff(FMLCommonSetupEvent event) {
            NuclearCraftPacketHandler.register();
        }
    }
}

