/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.blocks;

import com.song.nuclear_craft.blocks.tileentity.C4BombTileEntity;
import com.song.nuclear_craft.items.defuse_kit.DefuseKit;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public abstract class C4Bomb
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape FLOOR_H_X = Block.m_49796_((double)4.125, (double)0.0, (double)1.0, (double)12.0, (double)4.0, (double)15.0);
    protected static final VoxelShape FLOOR_H_Z = Block.m_49796_((double)1.0, (double)0.0, (double)4.125, (double)15.0, (double)4.0, (double)12.0);
    protected static final VoxelShape CEIL_H_X = Block.m_49796_((double)4.125, (double)12.0, (double)1.0, (double)12.0, (double)16.0, (double)15.0);
    protected static final VoxelShape CEIL_H_Z = Block.m_49796_((double)1.0, (double)12.0, (double)4.125, (double)15.0, (double)16.0, (double)12.0);
    protected static final VoxelShape WALL_E = Block.m_49796_((double)0.0, (double)4.125, (double)1.0, (double)4.0, (double)12.0, (double)15.0);
    protected static final VoxelShape WALL_W = Block.m_49796_((double)12.0, (double)4.125, (double)1.0, (double)16.0, (double)12.0, (double)15.0);
    protected static final VoxelShape WALL_S = Block.m_49796_((double)1.0, (double)4.125, (double)0.0, (double)15.0, (double)12.0, (double)4.0);
    protected static final VoxelShape WALL_N = Block.m_49796_((double)1.0, (double)4.125, (double)12.0, (double)15.0, (double)12.0, (double)16.0);

    public C4Bomb(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL));
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity entity;
        if (worldIn.m_46753_(pos) && (entity = worldIn.m_7702_(pos)) instanceof C4BombTileEntity) {
            ((C4BombTileEntity)entity).activate();
        }
    }

    public void explode(Level world, double x, double y, double z) {
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                if (direction.m_122434_() == Direction.Axis.X) {
                    return FLOOR_H_X;
                }
                return FLOOR_H_Z;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return WALL_E;
                    }
                    case WEST: {
                        return WALL_W;
                    }
                    case SOUTH: {
                        return WALL_S;
                    }
                }
                return WALL_N;
            }
        }
        if (direction.m_122434_() == Direction.Axis.X) {
            return CEIL_H_X;
        }
        return CEIL_H_Z;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, f_53179_});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (!worldIn.f_46443_) {
            this.m_6861_(state, worldIn, pos, (Block)this, pos, false);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemStack.m_41720_() instanceof DefuseKit) {
            C4BombTileEntity c4BombTileEntity;
            if (!worldIn.m_5776_() && (c4BombTileEntity = (C4BombTileEntity)worldIn.m_7702_(pos)) != null && c4BombTileEntity.currentDefuseStatus < 0) {
                c4BombTileEntity.currentDefuseStatus = 0;
                c4BombTileEntity.defuseTime = ((DefuseKit)itemStack.m_41720_()).getDefuseTick();
                c4BombTileEntity.defusingEntityID = player.m_142049_();
                c4BombTileEntity.defusingTool = Objects.requireNonNull(itemStack.m_41720_().getRegistryName()).toString();
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)21.0, (ResourceKey)worldIn.m_46472_())), (Object)new SoundPacket(pos, "defusing"));
            }
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof C4BombTileEntity) {
            ((C4BombTileEntity)tileentity).synToClient();
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((C4BombTileEntity)tileentity), (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return true;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }
}

