/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.blocks.tileentity;

import com.song.nuclear_craft.blocks.C4Bomb;
import com.song.nuclear_craft.blocks.container.C4BombContainer;
import com.song.nuclear_craft.items.defuse_kit.DefuseKit;
import com.song.nuclear_craft.network.BombDefuseProgressPacket;
import com.song.nuclear_craft.network.C4BombSynPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class C4BombTileEntity
extends BlockEntity
implements MenuProvider {
    private static final int DEFAULT_FUSE_TIME = 800;
    protected boolean is_active;
    protected int fuse_age;
    protected int explode_time;
    protected int threshold1;
    protected int threshold2;
    public String inputPanel = "";
    public int defuseTime = 100;
    public int currentDefuseStatus = -1;
    public int defusingEntityID = 0;
    public String defusingTool = "";

    public C4BombTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.is_active = false;
        this.fuse_age = 0;
        this.explode_time = 800;
        this.threshold1 = (int)((double)this.explode_time * 0.33);
        this.threshold2 = (int)((double)this.explode_time * 0.66);
    }

    public C4BombTileEntity(BlockEntityType<?> tileEntityTypeIn, int explode_time, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.explode_time = explode_time;
    }

    private int getBeepInterval() {
        if (this.fuse_age > this.explode_time - 40) {
            return 2;
        }
        if (this.fuse_age > this.threshold2) {
            return 8;
        }
        if (this.fuse_age > this.threshold1) {
            return 15;
        }
        return 20;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, C4BombTileEntity c4) {
        assert (level != null);
        if (c4.is_active && !level.f_46443_) {
            ++c4.fuse_age;
            c4.m_6596_();
            if (c4.fuse_age % c4.getBeepInterval() == 0) {
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)c4.f_58858_.m_123341_(), (double)c4.f_58858_.m_123342_(), (double)c4.f_58858_.m_123343_(), (double)20.0, (ResourceKey)c4.f_58857_.m_46472_())), (Object)new SoundPacket(c4.f_58858_, "c4_beep"));
                c4.synToClient();
            }
            if (c4.fuse_age >= c4.explode_time) {
                C4Bomb block = (C4Bomb)c4.m_58900_().m_60734_();
                BlockPos pos = c4.m_58899_();
                c4.m_7651_();
                level.m_7471_(pos, false);
                block.explode(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
        }
        if (!level.m_5776_() && c4.currentDefuseStatus >= 0) {
            c4.m_6596_();
            Entity entity = level.m_6815_(c4.defusingEntityID);
            if (entity != null) {
                if (c4.entityStillDefusing(entity)) {
                    ++c4.currentDefuseStatus;
                    if (c4.currentDefuseStatus % 4 == 0 && entity instanceof ServerPlayer) {
                        NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), (Object)new BombDefuseProgressPacket(c4.m_58899_(), c4.currentDefuseStatus, c4.defuseTime));
                    }
                    if (c4.currentDefuseStatus >= c4.defuseTime) {
                        c4.beDefused();
                    }
                } else {
                    c4.currentDefuseStatus = -1;
                    if (entity instanceof ServerPlayer) {
                        NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), (Object)new BombDefuseProgressPacket(c4.m_58899_(), -1, c4.defuseTime));
                    }
                }
            }
        }
    }

    protected boolean entityStillDefusing(Entity entity) {
        if (entity instanceof LivingEntity) {
            return entity.m_142538_().m_123314_((Vec3i)this.m_58899_(), 5.0) && Objects.requireNonNull(((LivingEntity)entity).m_21120_(InteractionHand.MAIN_HAND).m_41720_().getRegistryName()).toString().equals(this.defusingTool);
        }
        return false;
    }

    protected void beDefused() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_()) {
            ItemStack itemStack1;
            Block block = this.f_58857_.m_8055_(this.m_58899_()).m_60734_();
            ItemStack itemStack = new ItemStack((ItemLike)block.m_5456_());
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), itemStack));
            this.f_58857_.m_46961_(this.m_58899_(), false);
            NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)14.0, (ResourceKey)this.f_58857_.m_46472_())), (Object)new SoundPacket(this.f_58858_, "defused"));
            Entity entity = this.f_58857_.m_6815_(this.defusingEntityID);
            if (entity instanceof LivingEntity && (itemStack1 = ((LivingEntity)entity).m_21205_()).m_41720_() instanceof DefuseKit) {
                itemStack1.m_41622_(1, (LivingEntity)entity, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            }
        }
    }

    private void setActive() {
        this.is_active = true;
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)7.0, (ResourceKey)this.f_58857_.m_46472_())), (Object)new SoundPacket(this.f_58858_, "c4_activate"));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player entity) {
        return new C4BombContainer(id, inventory, this);
    }

    public Component m_5446_() {
        return new TranslatableComponent(String.format("menu.%s.c4_bomb.display_name", "nuclear_craft"));
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        CompoundTag nbt = super.m_6945_(compound);
        nbt.m_128405_("fuse_age", this.fuse_age);
        nbt.m_128405_("explode_time", this.explode_time);
        nbt.m_128379_("is_active", this.is_active);
        nbt.m_128405_("threshold1", this.threshold1);
        nbt.m_128405_("threshold2", this.threshold2);
        nbt.m_128359_("inputPanel", this.inputPanel);
        nbt.m_128405_("defuseTime", this.defuseTime);
        nbt.m_128405_("currentDefuseStatus", this.currentDefuseStatus);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fuse_age = nbt.m_128451_("fuse_age");
        this.explode_time = nbt.m_128451_("explode_time");
        this.is_active = nbt.m_128471_("is_active");
        this.threshold1 = nbt.m_128451_("threshold1");
        this.threshold2 = nbt.m_128451_("threshold2");
        this.inputPanel = nbt.m_128461_("inputPanel");
        this.defuseTime = nbt.m_128451_("defuseTime");
        this.currentDefuseStatus = nbt.m_128451_("currentDefuseStatus");
        this.synToClient();
    }

    public void delete() {
        if (!this.is_active) {
            this.inputPanel = "";
            this.synToClient();
            this.m_6596_();
        }
    }

    public void addNum(int num) {
        if (!this.is_active) {
            this.inputPanel = this.inputPanel + num;
            this.synToClient();
            this.m_6596_();
        }
    }

    public void activate() {
        if (!this.is_active) {
            this.explode_time = !this.inputPanel.isEmpty() ? Integer.parseInt(this.inputPanel) * 20 : 800;
            this.setActive();
            this.synToClient();
        }
    }

    public void synToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> {
                assert (this.f_58857_ != null);
                return this.f_58857_.m_46745_(this.f_58858_);
            }), (Object)new C4BombSynPacket(this.f_58858_, this.inputPanel, this.fuse_age, this.explode_time, this.is_active));
        }
    }

    public int getCounter() {
        return (this.explode_time - this.fuse_age) / 20;
    }

    public boolean isActive() {
        return this.is_active;
    }

    public void setAttr(String inputPanel, int fuse_age, int explode_time, boolean is_active) {
        this.inputPanel = inputPanel;
        this.fuse_age = fuse_age;
        this.explode_time = explode_time;
        this.is_active = is_active;
    }
}

