/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import com.song.nuclear_craft.entities.EntityRegister;
import com.song.nuclear_craft.items.AbstractAmmo;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.misc.ConfigCommon;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class AbstractAmmoEntity
extends ThrowableItemProjectile {
    private double energy;
    private double initSpeed;
    private double gravity = 0.03f;
    protected double baseDamage = 30.0;
    private int age = 0;
    private double bulletSize;
    private final IntOpenHashSet piercedEntities = new IntOpenHashSet(100);
    private boolean isMyImpact = false;
    private double initEnergy;
    private static final EntityDataAccessor<Float> CURRENT_MOTION_X = SynchedEntityData.m_135353_(ThrowableItemProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CURRENT_MOTION_Y = SynchedEntityData.m_135353_(ThrowableItemProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CURRENT_MOTION_Z = SynchedEntityData.m_135353_(ThrowableItemProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BULLET_SIZE = SynchedEntityData.m_135353_(ThrowableItemProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CURRENT_MOTION_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CURRENT_MOTION_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CURRENT_MOTION_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BULLET_SIZE, (Object)Float.valueOf(0.0f));
    }

    public AbstractAmmoEntity(EntityType<? extends AbstractAmmoEntity> type, Level world) {
        super(type, world);
    }

    public AbstractAmmoEntity(FMLPlayMessages.SpawnEntity entity, Level world) {
        this((EntityType<? extends AbstractAmmoEntity>)((EntityType)EntityRegister.BULLET_ENTITY.get()), world);
        this.m_20334_(entity.getVelX(), entity.getVelY(), entity.getVelZ());
        this.m_6541_(entity.getYaw(), entity.getPitch());
        this.m_6034_(entity.getPosX(), entity.getPosY(), entity.getPosZ());
    }

    public AbstractAmmoEntity(double x, double y, double z, Level world, ItemStack itemStack, Player shooter) {
        super((EntityType)EntityRegister.BULLET_ENTITY.get(), x, y, z, world);
        this.m_37446_(itemStack);
        this.m_5602_((Entity)shooter);
        this.bulletSize = ((AbstractAmmo)itemStack.m_41720_()).getSize().getSize();
        this.f_19804_.m_135381_(BULLET_SIZE, (Object)Float.valueOf((float)this.bulletSize));
        this.setBaseDamage(((AbstractAmmo)itemStack.m_41720_()).getBaseDamage());
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void m_8119_() {
        Vec3 vector3d;
        double kEBefore = -1.0;
        if (this.age == 0) {
            this.initSpeed = this.m_20184_().m_82553_();
            this.bulletSize = ((Float)this.f_19804_.m_135370_(BULLET_SIZE)).floatValue();
            this.initEnergy = this.energy = this.getEnergy(this.initSpeed);
        }
        if (this.f_19853_.f_46443_) {
            this.m_20334_(((Float)this.f_19804_.m_135370_(CURRENT_MOTION_X)).floatValue(), ((Float)this.f_19804_.m_135370_(CURRENT_MOTION_Y)).floatValue(), ((Float)this.f_19804_.m_135370_(CURRENT_MOTION_Z)).floatValue());
        } else {
            vector3d = this.m_20184_();
            this.f_19804_.m_135381_(CURRENT_MOTION_X, (Object)Float.valueOf((float)vector3d.f_82479_));
            this.f_19804_.m_135381_(CURRENT_MOTION_Y, (Object)Float.valueOf((float)vector3d.f_82480_));
            this.f_19804_.m_135381_(CURRENT_MOTION_Z, (Object)Float.valueOf((float)vector3d.f_82481_));
        }
        this.isMyImpact = true;
        if (!this.f_19853_.f_46443_) {
            HitResult raytraceresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
            while (!this.m_146910_() && raytraceresult != null) {
                raytraceresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
                if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                    Entity indirect = this.m_37282_();
                    if (entity instanceof Player && indirect instanceof Player && !((Player)indirect).m_7099_((Player)entity)) {
                        raytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                    this.m_6532_(raytraceresult);
                }
                if (raytraceresult == null || raytraceresult.m_6662_() != HitResult.Type.MISS) continue;
            }
        }
        this.isMyImpact = false;
        super.m_8119_();
        if (this.energy <= 0.0) {
            this.m_142467_(Entity.RemovalReason.KILLED);
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, -this.gravity, 0.0));
        ++this.age;
        vector3d = this.m_20184_();
        float f = (float)vector3d.m_165925_();
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        if (this.age >= 1000) {
            this.m_142467_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_5790_(@Nonnull EntityHitResult entityRayTraceResult) {
        Entity entity = entityRayTraceResult.m_82443_();
        this.piercedEntities.add(entity.m_142049_());
        if (entity instanceof ItemEntity || entity instanceof AbstractAmmoEntity) {
            return;
        }
        if (entity instanceof LivingEntity) {
            entity.f_19802_ = 0;
        }
        double damage = this.baseDamage * this.getEnergy(this.m_20184_().m_82553_()) / this.initEnergy;
        DamageSource damageSource = new IndirectEntityDamageSource(new ResourceLocation("nuclear_craft", "bullet").toString(), (Entity)this, this.m_37282_()).m_19366_();
        boolean result = entity.m_6469_(damageSource, (float)damage);
        this.energy = result ? (this.energy -= 30.0) : (this.energy -= 10.0);
    }

    protected void m_6532_(HitResult result) {
        double kEBefore = this.energy;
        if (this.isMyImpact && !this.f_19853_.f_46443_) {
            super.m_6532_(result);
        }
        if (this.energy <= 0.0) {
            this.m_142467_(Entity.RemovalReason.KILLED);
        }
        double factor = Math.sqrt(this.energy / kEBefore);
        this.m_20256_(this.m_20184_().m_82542_(factor, factor, factor));
    }

    protected boolean m_5603_(Entity p_230298_1_) {
        return super.m_5603_(p_230298_1_) && (this.piercedEntities == null || !this.piercedEntities.contains(p_230298_1_.m_142049_()));
    }

    protected void m_8060_(@Nonnull BlockHitResult blockRayTraceResult) {
        Block block = this.f_19853_.m_8055_(blockRayTraceResult.m_82425_()).m_60734_();
        double blastResist = block.m_7325_();
        if (blastResist > this.getBlockBreakThreshold() + 0.001) {
            Direction blockDirection = blockRayTraceResult.m_82434_();
            this.ricochetSpeed(blockDirection);
            this.teleportToHitPoint((HitResult)blockRayTraceResult);
            this.energy -= this.initEnergy * this.getRicochetEnergyLoss();
        } else {
            this.f_19853_.m_46961_(blockRayTraceResult.m_82425_(), true);
            this.energy -= this.getEnergyLoss(blastResist);
        }
        this.piercedEntities.clear();
    }

    protected void teleportToHitPoint(HitResult rayTraceResult) {
        Vec3 hitResult = rayTraceResult.m_82450_();
        this.m_6034_(hitResult.f_82479_, hitResult.f_82480_, hitResult.f_82481_);
    }

    public double getRicochetEnergyLoss() {
        return 0.5;
    }

    public double getBlockBreakThreshold() {
        return (Double)ConfigCommon.AMMO_BLOCK_BREAK_THRESHOLD.get();
    }

    public double getEnergyLoss(double blastResist) {
        return 25.0 + 10.0 * (blastResist - 2.0);
    }

    private void ricochetSpeed(Direction direction) {
        switch (direction) {
            case UP: 
            case DOWN: {
                this.m_20256_(this.m_20184_().m_82542_(1.0, -1.0, 1.0));
                break;
            }
            case EAST: 
            case WEST: {
                this.m_20256_(this.m_20184_().m_82542_(-1.0, 1.0, 1.0));
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.m_20256_(this.m_20184_().m_82542_(1.0, 1.0, -1.0));
                break;
            }
        }
    }

    protected double getEnergy(double speed) {
        return 0.5 * speed * speed * (this.bulletSize / 9.0);
    }

    protected Item m_7881_() {
        return (Item)ItemList.AMMO_REGISTRIES_TYPE.get((Object)AmmoSize.SIZE_9MM).get((Object)AmmoType.NORMAL).get();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

