/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import com.google.common.collect.Lists;
import com.song.nuclear_craft.misc.ConfigCommon;
import com.song.nuclear_craft.misc.NukeExplosion;
import com.song.nuclear_craft.network.MySExplosionPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.particles.ParticleRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class ExplosionUtils {
    public static final float NUKE_RADIUS = ((Double)ConfigCommon.NUKE_RADIUS.get()).floatValue();
    public static final double MAX_BLAST_POWER = (Double)ConfigCommon.NUKE_BLAST_POWER.get();
    public static final float Y_SHORTEN = 1.5f;

    public static double getBlastPower(double dist, double radius) {
        double decay_rd = radius * 0.95;
        if (dist < decay_rd) {
            return 1.1;
        }
        return -(1.0 / (radius - decay_rd)) * (dist - decay_rd) + 1.0;
    }

    public static List<BlockPos> getAffectedBlockPositions(Level world, double x, double y, double z, float radius, double max_blast_power) {
        ArrayList affectedBlockPositions = Lists.newArrayList();
        int radius_int = (int)Math.ceil(radius);
        for (int dx = -radius_int; dx < radius_int + 1; ++dx) {
            int y_lim = (int)(Math.sqrt(radius_int * radius_int - dx * dx) / 1.5);
            for (int dy = -y_lim; dy < y_lim + 1; ++dy) {
                int z_lim = (int)Math.sqrt((float)(radius_int * radius_int - dx * dx) - (float)(dy * dy) * 1.5f * 1.5f);
                for (int dz = -z_lim; dz < z_lim + 1; ++dz) {
                    float resistance;
                    BlockPos blockPos = new BlockPos(x + (double)dx, y + (double)dy, z + (double)dz);
                    BlockState blockState = world.m_8055_(blockPos);
                    double power = ExplosionUtils.getBlastPower(Math.sqrt((float)(dx * dx) + (float)(dy * dy) * 1.5f * 1.5f + (float)(dz * dz)), radius);
                    if (blockState == Blocks.f_50016_.m_49966_()) continue;
                    if (!(power > 1.0)) {
                        Random random = new Random();
                        if (!(power > random.nextDouble())) continue;
                    }
                    if (!((double)(resistance = blockState.m_60734_().m_7325_()) < max_blast_power)) continue;
                    affectedBlockPositions.add(blockPos);
                }
            }
        }
        return affectedBlockPositions;
    }

    public static Explosion oldNukeExplode(Level world, Entity entity, double x, double y, double z, float radius, boolean spawnCloud, double max_blast_power) {
        List<BlockPos> affectedBlockPositions = ExplosionUtils.getAffectedBlockPositions(world, x, y, z, radius, max_blast_power);
        NukeExplosion nukeExplosion = new NukeExplosion(world, entity, x, y, z, radius, affectedBlockPositions);
        nukeExplosion.m_46061_();
        nukeExplosion.m_46075_(false);
        for (Player playerentity : world.m_6907_()) {
            ServerPlayer serverplayerentity = (ServerPlayer)playerentity;
            if (!(serverplayerentity.m_20275_(x, y, z) < 65536.0)) continue;
            serverplayerentity.f_8906_.m_141995_((Packet)new ClientboundExplodePacket(x, y, z, radius, nukeExplosion.m_46081_(), (Vec3)nukeExplosion.m_46078_().get(serverplayerentity)));
            if (!spawnCloud) continue;
            NuclearCraftPacketHandler.EXPLOSION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverplayerentity), (Object)new MySExplosionPacket(radius, x, y, z));
        }
        ExplosionUtils.playNukeSound(world, x, y, z, radius);
        world.m_46511_(entity, x, y, z, radius * 0.8f, Explosion.BlockInteraction.BREAK);
        return nukeExplosion;
    }

    public static Explosion oldNukeExplode(Level world, Entity entity, double x, double y, double z, float radius, boolean spawnCloud) {
        return ExplosionUtils.oldNukeExplode(world, entity, x, y, z, radius, spawnCloud, MAX_BLAST_POWER);
    }

    public static void playNukeSound(Level world, double x, double y, double z, double radius) {
        world.m_6263_(null, x, y, z, SoundEvents.f_11913_, SoundSource.BLOCKS, (float)(40.0 * radius / (double)NUKE_RADIUS), (1.0f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.2f) * 0.7f);
    }

    @Deprecated
    public static void multiExplode(Level world, Entity entity, double x, double y, double z, float radius, int intensity) {
        float hf_rd = radius / 4.0f;
        for (int i = -intensity; i < intensity + 1; ++i) {
            for (int j = -intensity; j < intensity + 1; ++j) {
                for (int k = -intensity; k < 1; ++k) {
                    if (!(Math.sqrt(i * i + j * j + k * k) < (double)intensity + 0.1)) continue;
                    world.m_46511_(entity, x + (double)(hf_rd * (float)i), y + (double)(hf_rd * (float)k), z + (double)(hf_rd * (float)j), radius, Explosion.BlockInteraction.BREAK);
                }
            }
        }
    }

    public static void mushroomCloud(double x, double y, double z, double radius) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world.f_46443_) {
            int MAX_STEP_Y = (int)Math.ceil(1.25 * radius);
            double step_y = 2.986 * radius / (double)MAX_STEP_Y;
            for (int step = 0; step < MAX_STEP_Y; ++step) {
                double this_r = 0.0;
                double delta_y = (double)step * step_y;
                if (delta_y < radius / 3.0) {
                    this_r = radius - delta_y * 2.0;
                } else if (delta_y < radius) {
                    this_r = radius / 3.0;
                } else if (delta_y < 2.98 * radius) {
                    this_r = Math.sqrt(radius * radius - (1.986 * radius - delta_y) * (1.986 * radius - delta_y));
                }
                int n_render = (int)Math.ceil(0.75 * this_r);
                double theta_step = 6.28 / (double)n_render;
                for (int i = 0; i < n_render; ++i) {
                    double theta = theta_step * (double)i;
                    double delta_x = this_r * Math.cos(theta);
                    double delta_z = this_r * Math.sin(theta);
                    if (delta_y > radius) {
                        world.m_6493_((ParticleOptions)ParticleRegister.NUKE_PARTICLE_FIRE.get(), true, x + delta_x, y + delta_y, z + delta_z, 0.0, 0.07, 0.0);
                        continue;
                    }
                    world.m_6493_((ParticleOptions)ParticleRegister.NUKE_PARTICLE_SMOKE.get(), true, x + delta_x, y + delta_y, z + delta_z, 0.0, 0.07, 0.0);
                }
            }
        }
    }
}

