/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import com.song.nuclear_craft.effects.EffectRegister;
import com.song.nuclear_craft.entities.EntityRegister;
import com.song.nuclear_craft.entities.ExplosionUtils;
import com.song.nuclear_craft.misc.ConfigCommon;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.NukeMushroomCloudPacket;
import com.song.nuclear_craft.network.NukeRisingSmokePacket;
import com.song.nuclear_craft.network.ParticlePacket;
import com.song.nuclear_craft.network.ShockWaveParticleChannel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class NukeExplosionHandler
extends Entity {
    private int age = 0;

    public NukeExplosionHandler(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public NukeExplosionHandler(double x, double y, double z, Level world) {
        super((EntityType)EntityRegister.NUKE_EXPLOSION_HANDLER_TYPE.get(), world);
        this.m_6034_(x, y, z);
        this.onSpawn();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.age = compound.m_128451_("age");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("age", this.age);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_20147_() {
        return true;
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
    }

    private void onSpawn() {
        if (!this.f_19853_.m_5776_()) {
            for (Player player : this.f_19853_.m_6907_()) {
                if (!(this.getDistanceSquare(player) < NukeExplosionHandler.getVisionEffectDist())) continue;
                player.m_7292_(new MobEffectInstance((MobEffect)EffectRegister.RADIOACTIVE.get(), 1600, 1));
            }
            NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ParticlePacket(this.m_20185_(), this.m_20186_(), this.m_20189_(), "nuke_core"));
        }
    }

    private double getDistanceSquare(Player player) {
        return player.m_20270_((Entity)this);
    }

    private static double getVisionEffectDist() {
        return 400.0;
    }

    public static float getBlastRadius() {
        return ((Double)ConfigCommon.NUKE_RADIUS.get()).floatValue();
    }

    public static int getStageOneTick() {
        return 20;
    }

    public static int getStageTwoTick() {
        return 80;
    }

    public static int getStageThreeTick() {
        return 560;
    }

    public void shockWave() {
        if (!this.f_19853_.m_5776_()) {
            float multiplier = 2.0f;
            int effectiveHeight = 15;
            int effectRadius = (int)(multiplier * NukeExplosionHandler.getBlastRadius());
            for (int dx = -effectRadius; dx <= effectRadius; ++dx) {
                int yMax = (int)Math.sqrt(effectRadius * effectRadius - dx * dx);
                block1: for (int dz = -yMax; dz <= yMax; ++dz) {
                    int y = this.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)this.m_20185_() + dx, (int)this.m_20189_() + dz);
                    BlockPos interested = new BlockPos((int)this.m_20185_() + dx, y - 1, (int)this.m_20189_() + dz);
                    if (!((double)y - this.m_20186_() < (double)effectiveHeight) && !((double)y - this.m_20186_() > (double)(-effectiveHeight))) continue;
                    while ((double)y - this.m_20186_() > (double)(-effectiveHeight)) {
                        BlockPos interested1 = new BlockPos((int)this.m_20185_() + dx, y - 1, (int)this.m_20189_() + dz);
                        BlockState blockState = this.f_19853_.m_8055_(interested);
                        this.f_19853_.m_46961_(interested1, false);
                        if (blockState.m_60767_() != Material.f_76320_ && blockState.m_60767_() != Material.f_76274_) continue block1;
                        --y;
                    }
                }
            }
        }
    }

    public void effectCore() {
        if (!this.f_19853_.m_5776_()) {
            float multiplier = 2.0f;
            int effectiveHeight = 15;
            int effectRadius = (int)(multiplier * NukeExplosionHandler.getBlastRadius());
            for (int dx = -effectRadius; dx <= effectRadius; ++dx) {
                int yMax = (int)Math.sqrt(effectRadius * effectRadius - dx * dx);
                for (int dz = -yMax; dz <= yMax; ++dz) {
                    int y = this.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)this.m_20185_() + dx, (int)this.m_20189_() + dz);
                    BlockPos interested = new BlockPos((int)this.m_20185_() + dx, y - 1, (int)this.m_20189_() + dz);
                    if (!((float)(dx * dx + dz * dz) < NukeExplosionHandler.getBlastRadius() * NukeExplosionHandler.getBlastRadius())) continue;
                    if ((double)this.f_19796_.nextFloat() < 0.5) {
                        this.f_19853_.m_46597_(interested, Blocks.f_50134_.m_49966_());
                        if ((double)this.f_19796_.nextFloat() < 0.2) {
                            this.f_19853_.m_46597_(interested.m_142300_(Direction.UP), Blocks.f_50083_.m_49966_());
                        }
                    }
                    if (!((double)this.f_19796_.nextFloat() < 0.05)) continue;
                    this.f_19853_.m_46597_(interested, Blocks.f_49991_.m_49966_());
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            if (this.age == NukeExplosionHandler.getStageOneTick()) {
                ExplosionUtils.oldNukeExplode(this.f_19853_, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), NukeExplosionHandler.getBlastRadius(), false, (Double)ConfigCommon.NUKE_BLAST_POWER.get());
                this.effectCore();
            }
            if (this.age == NukeExplosionHandler.getStageTwoTick() - 15) {
                NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ShockWaveParticleChannel(this.m_20185_(), this.m_20186_(), this.m_20189_(), NukeExplosionHandler.getBlastRadius()));
            }
            if (this.age == NukeExplosionHandler.getStageTwoTick() + 10) {
                this.shockWave();
            }
            if (this.age >= NukeExplosionHandler.getStageTwoTick() && this.age % 10 == 0) {
                NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NukeRisingSmokePacket(this.m_20185_(), this.m_20186_() - (double)(NukeExplosionHandler.getBlastRadius() / 1.5f) + 1.0, this.m_20189_(), 0.1 * (double)NukeExplosionHandler.getBlastRadius()));
            }
            if (this.age >= NukeExplosionHandler.getStageThreeTick() && this.age % 10 == 0) {
                NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NukeMushroomCloudPacket(this.m_20185_(), this.m_20186_() + 1.75 * (double)NukeExplosionHandler.getBlastRadius() - (double)(NukeExplosionHandler.getBlastRadius() / 1.5f) + 1.0, this.m_20189_(), 0.25 * (double)NukeExplosionHandler.getBlastRadius()));
            }
            ++this.age;
            if (this.age >= 3000) {
                this.m_142467_(Entity.RemovalReason.KILLED);
            }
        }
    }
}

