/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;

public class ShockWaveEntity
extends ArmorStand {
    private int life = 0;
    private int radius;
    private final int maxLife;

    public ShockWaveEntity(Level worldIn, double posX, double posY, double posZ, int maxLife, int radius) {
        super(EntityType.f_20529_, worldIn);
        this.m_6034_(posX, posY, posZ);
        this.maxLife = maxLife;
        this.m_20068_();
        this.radius = radius;
    }

    public ShockWaveEntity(Level world, double x, double y, double z, int maxLife) {
        this(world, x, y, z, maxLife, 0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.life > this.maxLife) {
            this.m_142467_(Entity.RemovalReason.KILLED);
        }
        if (!this.f_19853_.m_5776_() && this.life % 10 == 0) {
            int maxStep = this.radius * 6;
            int maxDy = 3;
            for (int step = 0; step < maxStep; ++step) {
                double theta = Math.PI * 2 * (double)step / (double)maxStep;
                double x = this.m_20185_() + Math.cos(theta) * (double)this.radius;
                double z = this.m_20189_() + Math.sin(theta) * (double)this.radius;
                for (int dy = -maxDy; dy <= maxDy; ++dy) {
                    this.f_19853_.m_46961_(new BlockPos(x, (double)dy + this.m_20186_(), z), true);
                }
            }
            ++this.radius;
        }
        ++this.life;
    }
}

