/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities.rocket_entities;

import com.song.nuclear_craft.misc.ConfigCommon;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class IncendiaryRocketEntity
extends FireworkRocketEntity {
    public static int N_FIRE_BALLS = (Integer)ConfigCommon.INCENDIARY_COUNT.get();

    public IncendiaryRocketEntity(EntityType<? extends FireworkRocketEntity> p_i50164_1_, Level p_i50164_2_) {
        super(p_i50164_1_, p_i50164_2_);
    }

    public IncendiaryRocketEntity(Level worldIn, double x, double y, double z, ItemStack givenItem) {
        super(worldIn, x, y, z, givenItem);
    }

    public IncendiaryRocketEntity(Level p_i231581_1_, @Nullable Entity p_i231581_2_, double p_i231581_3_, double p_i231581_5_, double p_i231581_7_, ItemStack p_i231581_9_) {
        super(p_i231581_1_, p_i231581_2_, p_i231581_3_, p_i231581_5_, p_i231581_7_, p_i231581_9_);
    }

    public IncendiaryRocketEntity(Level p_i47367_1_, ItemStack p_i47367_2_, LivingEntity p_i47367_3_) {
        super(p_i47367_1_, p_i47367_2_, p_i47367_3_);
    }

    public IncendiaryRocketEntity(Level p_i50165_1_, ItemStack p_i50165_2_, double p_i50165_3_, double p_i50165_5_, double p_i50165_7_, boolean p_i50165_9_) {
        super(p_i50165_1_, p_i50165_2_, p_i50165_3_, p_i50165_5_, p_i50165_7_, p_i50165_9_);
    }

    public IncendiaryRocketEntity(Level p_i231582_1_, ItemStack p_i231582_2_, Entity p_i231582_3_, double p_i231582_4_, double p_i231582_6_, double p_i231582_8_, boolean p_i231582_10_) {
        super(p_i231582_1_, p_i231582_2_, p_i231582_3_, p_i231582_4_, p_i231582_6_, p_i231582_8_, p_i231582_10_);
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult) {
        this.m_142467_(Entity.RemovalReason.KILLED);
        if (!this.f_19853_.f_46443_) {
            double validY = IncendiaryRocketEntity.getValidY(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            IncendiaryRocketEntity.fireExplode(this.f_19853_, this.m_20185_(), validY, this.m_20189_());
        }
    }

    protected void m_8060_(BlockHitResult blockRayTraceResult) {
        this.m_142467_(Entity.RemovalReason.KILLED);
        if (!this.f_19853_.f_46443_) {
            double validY = IncendiaryRocketEntity.getValidY(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            IncendiaryRocketEntity.fireExplode(this.f_19853_, this.m_20185_(), validY, this.m_20189_());
        }
    }

    public static void fireExplode(Level world, double x, double y, double z) {
        IncendiaryRocketEntity.fireExplode(world, x, y, z, N_FIRE_BALLS);
    }

    public static void fireExplode(Level world, double x, double y, double z, int maxBalls) {
        Random random = new Random();
        world.m_6263_(null, x, y, z, SoundEvents.f_11705_, SoundSource.BLOCKS, 10.0f, 0.3f);
        for (int i = 0; i < maxBalls; ++i) {
            double r = random.nextDouble() + 5.0;
            double theta = random.nextDouble() * 3.14 * 2.0;
            double phi = random.nextDouble() * 1.36 + 1.76;
            world.m_7967_((Entity)new SmallFireball(world, x, y, z, r * Math.cos(theta) * Math.sin(phi), r * Math.cos(phi), r * Math.sin(theta) * Math.sin(phi)));
        }
    }

    public static double getValidY(Level world, double x, double y, double z) {
        for (double deltaY = 5.0; deltaY > -5.0; deltaY -= 1.0) {
            if (world.m_8055_(new BlockPos(x, y + deltaY, z)) != Blocks.f_50016_.m_49966_()) continue;
            return y + deltaY;
        }
        return y + 5.0;
    }
}

