/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities.rocket_entities;

import com.song.nuclear_craft.misc.ConfigCommon;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.ParticlePacket;
import com.song.nuclear_craft.particles.ParticleRegister;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class SmokeRocketEntity
extends FireworkRocketEntity {
    public static double SMOKE_RADIUS = ((Double)ConfigCommon.SMOKE_RADIUS.get()).floatValue();

    public SmokeRocketEntity(EntityType<? extends FireworkRocketEntity> p_i50164_1_, Level p_i50164_2_) {
        super(p_i50164_1_, p_i50164_2_);
    }

    public SmokeRocketEntity(Level worldIn, double x, double y, double z, ItemStack givenItem) {
        super(worldIn, x, y, z, givenItem);
    }

    public SmokeRocketEntity(Level p_i231581_1_, @Nullable Entity p_i231581_2_, double p_i231581_3_, double p_i231581_5_, double p_i231581_7_, ItemStack p_i231581_9_) {
        super(p_i231581_1_, p_i231581_2_, p_i231581_3_, p_i231581_5_, p_i231581_7_, p_i231581_9_);
    }

    public SmokeRocketEntity(Level p_i47367_1_, ItemStack p_i47367_2_, LivingEntity p_i47367_3_) {
        super(p_i47367_1_, p_i47367_2_, p_i47367_3_);
    }

    public SmokeRocketEntity(Level p_i50165_1_, ItemStack p_i50165_2_, double p_i50165_3_, double p_i50165_5_, double p_i50165_7_, boolean p_i50165_9_) {
        super(p_i50165_1_, p_i50165_2_, p_i50165_3_, p_i50165_5_, p_i50165_7_, p_i50165_9_);
    }

    public SmokeRocketEntity(Level p_i231582_1_, ItemStack p_i231582_2_, Entity p_i231582_3_, double p_i231582_4_, double p_i231582_6_, double p_i231582_8_, boolean p_i231582_10_) {
        super(p_i231582_1_, p_i231582_2_, p_i231582_3_, p_i231582_4_, p_i231582_6_, p_i231582_8_, p_i231582_10_);
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        this.explode();
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        this.explode();
    }

    private void explode() {
        this.m_142467_(Entity.RemovalReason.KILLED);
        if (!this.f_19853_.f_46443_) {
            SmokeRocketEntity.sendSmokePacket(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public static void sendSmokePacket(Level world, double x, double y, double z) {
        world.m_6263_(null, x, y, z, SoundEvents.f_12031_, SoundSource.BLOCKS, 20.0f, 1.0f);
        for (Player playerEntity : world.m_6907_()) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
            NuclearCraftPacketHandler.PARTICLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayerEntity), (Object)new ParticlePacket(x, y, z, "smoke_bomb"));
        }
    }

    public static void generateSmoke(double x, double y, double z) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        Random random = new Random();
        for (double deltaX = -SMOKE_RADIUS; deltaX <= SMOKE_RADIUS; deltaX += 3.0) {
            for (double deltaY = -SMOKE_RADIUS; deltaY <= SMOKE_RADIUS; deltaY += 3.0) {
                for (double deltaZ = -SMOKE_RADIUS; deltaZ <= SMOKE_RADIUS; deltaZ += 3.0) {
                    if (!(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ < SMOKE_RADIUS * SMOKE_RADIUS) || !(random.nextDouble() > 0.7) || world.m_8055_(new BlockPos(x + deltaX, y + deltaY, z + deltaZ)) != Blocks.f_50016_.m_49966_()) continue;
                    world.m_7106_((ParticleOptions)ParticleRegister.BIG_SMOKE.get(), x + deltaX, y + deltaY, z + deltaZ, 0.03 * (random.nextDouble() - 0.5), 0.03 * (random.nextDouble() - 0.5), 0.03 * (random.nextDouble() - 0.5));
                }
            }
        }
    }
}

