/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.entities.rocket_entities;

import com.song.nuclear_craft.entities.ExplosionUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WaterDropRocketEntity
extends FireworkRocketEntity {
    private int meltCD = 7;
    private final int maxLife;
    private int age = 0;

    public WaterDropRocketEntity(Level world, ItemStack itemStack, Entity entity, double v, double v1, double v2, boolean b) {
        super(world, itemStack, entity, v, v1, v2, b);
        this.maxLife = 10000;
    }

    public WaterDropRocketEntity(Level world, ItemStack itemStack, Entity entity, double v, double v1, double v2, boolean b, int maxLife) {
        super(world, itemStack, entity, v, v1, v2, b);
        this.maxLife = maxLife;
    }

    protected void m_5790_(EntityHitResult rayTraceResult) {
        Vec3 hitPoint = rayTraceResult.m_82450_();
        this.meltDown(this.f_19853_, hitPoint.f_82479_, hitPoint.f_82480_, hitPoint.f_82481_);
        this.meltCD = 2;
    }

    protected void m_8060_(BlockHitResult rayTraceResult) {
        Vec3 hitPoint = rayTraceResult.m_82450_();
        this.meltDown(this.f_19853_, hitPoint.f_82479_, hitPoint.f_82480_, hitPoint.f_82481_);
        this.meltCD = 2;
    }

    public void m_8119_() {
        super.m_8119_();
        if (--this.meltCD == 0) {
            this.meltDown(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.meltCD = 2;
        }
        if (!this.f_19853_.f_46443_) {
            ++this.age;
            if (this.m_20186_() > 300.0 && this.m_20184_().m_7098_() > 0.0) {
                this.m_142467_(Entity.RemovalReason.KILLED);
            }
            if (this.age > this.maxLife) {
                this.m_142467_(Entity.RemovalReason.KILLED);
            }
        }
    }

    private void meltDown(Level world, double x, double y, double z) {
        if (!world.f_46443_) {
            float radius = 10.0f;
            List<BlockPos> affectedBlockPositions = ExplosionUtils.getAffectedBlockPositions(world, x, y, z, radius, 3600002.0);
            for (BlockPos blockPos : affectedBlockPositions) {
                if (blockPos.m_123314_(new Vec3i(x, y, z), (double)(radius / 4.0f))) {
                    world.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                    continue;
                }
                Block block = world.m_8055_(blockPos).m_60734_();
                if (block == Blocks.f_50069_) {
                    world.m_46597_(blockPos, Blocks.f_50730_.m_49966_());
                    continue;
                }
                if (BlockTags.f_13106_.m_8110_((Object)block)) {
                    world.m_46597_(blockPos, Blocks.f_50353_.m_49966_());
                    continue;
                }
                if (block == Blocks.f_50752_) {
                    world.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
                    continue;
                }
                if ((double)this.f_19796_.nextFloat() < 0.95) {
                    world.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                    continue;
                }
                world.m_46597_(blockPos, (BlockState)Blocks.f_49991_.m_49966_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(15)));
            }
        }
    }
}

