/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.song.nuclear_craft.blocks.container.C4BombContainer;
import com.song.nuclear_craft.blocks.container.C4BombContainerScreen;
import com.song.nuclear_craft.client.ScopeZoomGui;
import com.song.nuclear_craft.items.guns.AbstractGunItem;
import com.song.nuclear_craft.misc.SoundEventList;
import com.song.nuclear_craft.network.C4BombSettingPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nuclear_craft", value={Dist.CLIENT})
public class ClientEventForgeSubscriber {
    private static final ResourceLocation BUTTON_X = new ResourceLocation("nuclear_craft", "textures/gui/button/button_x.png");
    private static final ResourceLocation BUTTON_SKELETON = new ResourceLocation("nuclear_craft", "textures/gui/button/button_skeleton.png");
    public static KeyMapping gunReload;
    public static KeyMapping zoom;
    private static int zoomState;
    private static int prevZoomState;
    private static double mouseSensitivityBefore;
    private static final float fovBefore = 1.0f;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack matrixStack = event.getMatrixStack();
        matrixStack.m_85836_();
        VertexConsumer builder = renderTypeBuffer.m_6299_(RenderType.m_110466_());
        builder.m_85950_(255.0f, 0.0f, 0.0f, 255.0f);
        renderTypeBuffer.m_109912_(RenderType.m_110466_());
        matrixStack.m_85849_();
    }

    @SubscribeEvent
    public void onInitGuiEvent(GuiScreenEvent.InitGuiEvent event) {
        Screen gui = event.getGui();
        if (gui instanceof C4BombContainerScreen) {
            int i = (gui.f_96543_ - ((C4BombContainerScreen)gui).getXSize()) / 2;
            int j = (gui.f_96544_ - ((C4BombContainerScreen)gui).getYSize()) / 2;
            int input_id = 1;
            block0: for (int row = 0; row <= 2; ++row) {
                for (int col = 0; col <= 3; ++col) {
                    int finalInput_id = input_id;
                    event.addWidget((GuiEventListener)new Button(i + 14 + col * 30, j + 57 + row * 30, 20, 20, (Component)new TextComponent("" + input_id), button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).m_6262_()).tileEntity.m_58899_(), "add_" + finalInput_id))));
                    ++input_id;
                    if (row != 2) continue;
                    ++row;
                    continue block0;
                }
            }
            event.addWidget((GuiEventListener)new Button(i + 44, j + 117, 20, 20, (Component)new TextComponent("0"), button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).m_6262_()).tileEntity.m_58899_(), "add_0"))));
            event.addWidget((GuiEventListener)new ImageButton(i + 74, j + 117, 20, 20, 0, 0, 2, BUTTON_X, 20, 20, button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).m_6262_()).tileEntity.m_58899_(), "delete"))));
            event.addWidget((GuiEventListener)new ImageButton(i + 104, j + 117, 20, 20, 0, 0, 2, BUTTON_SKELETON, 20, 20, button -> NuclearCraftPacketHandler.C4_SETTING_CHANNEL.sendToServer((Object)new C4BombSettingPacket(((C4BombContainer)((C4BombContainerScreen)gui).m_6262_()).tileEntity.m_58899_(), "activate"))));
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        Player entity = event.getEntity();
        Item item = entity.m_21205_().m_41720_();
        if (zoom.m_90859_()) {
            if (item instanceof AbstractGunItem && ((AbstractGunItem)item).canUseScope()) {
                zoomState = (zoomState + 1) % 3;
                entity.m_5496_(SoundEventList.ZOOM, 1.0f, 1.0f);
            }
        } else if (!(item instanceof AbstractGunItem) || !((AbstractGunItem)item).canUseScope()) {
            zoomState = 0;
        }
        switch (zoomState) {
            default: {
                if (prevZoomState != 0) {
                    Minecraft.m_91087_().f_91066_.f_92053_ = mouseSensitivityBefore;
                } else {
                    mouseSensitivityBefore = Minecraft.m_91087_().f_91066_.f_92053_;
                }
                prevZoomState = 0;
                break;
            }
            case 1: {
                event.setNewfov(0.33f);
                Minecraft.m_91087_().f_91066_.f_92053_ = 0.33 * mouseSensitivityBefore;
                prevZoomState = 1;
                break;
            }
            case 2: {
                event.setNewfov(0.1f);
                Minecraft.m_91087_().f_91066_.f_92053_ = 0.1 * mouseSensitivityBefore;
                prevZoomState = 2;
            }
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent event) {
        if (zoomState > 0) {
            Window window = event.getWindow();
            new ScopeZoomGui(Minecraft.m_91087_()).drawGuiContainerBackgroundLayer(event.getMatrixStack(), window.m_85447_(), window.m_85448_(), window.m_85445_(), window.m_85446_());
        }
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent event) {
        Player playerEntity = event.getPlayer();
        if (playerEntity.m_21205_().m_41720_() instanceof AbstractGunItem && event.isCancelable()) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
    }

    @SubscribeEvent
    public void onHandRender(RenderHandEvent event) {
        if (zoomState > 0) {
            event.setCanceled(true);
        }
    }

    static {
        zoomState = 0;
        prevZoomState = 0;
        mouseSensitivityBefore = Minecraft.m_91087_().f_91066_.f_92053_;
    }
}

