/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items;

import com.song.nuclear_craft.items.Ammo.AmmoPossibleCombination;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.misc.ConfigCommon;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class AbstractAmmo
extends Item {
    private final AmmoSize size;
    private final AmmoType type;
    private final int extraTooltipLine;

    public AbstractAmmo(Item.Properties properties, AmmoSize size, AmmoType type) {
        this(properties, size, type, 0);
    }

    public AbstractAmmo(Item.Properties properties, AmmoSize size, AmmoType type, int extraTooltipLine) {
        super(properties);
        this.size = size;
        this.type = type;
        this.extraTooltipLine = extraTooltipLine;
    }

    @Nonnull
    public AmmoSize getSize() {
        return this.size;
    }

    @Nonnull
    public AmmoType getType() {
        return this.type;
    }

    public double getBaseDamage() {
        return (Double)ConfigCommon.DAMAGE_MAP.get((Object)this.size).get((Object)this.type).get();
    }

    public float getBaseSpeed() {
        return ((Double)ConfigCommon.SPEED_MAP.get((Object)this.size).get((Object)this.type).get()).floatValue();
    }

    public double getGravity() {
        return (Double)ConfigCommon.GRAVITY_MAP.get((Object)this.size).get((Object)this.type).get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        for (int l = 0; l < this.extraTooltipLine; ++l) {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.%s.line%d", "nuclear_craft", Objects.requireNonNull(this.getRegistryName()).m_135815_(), l)).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.ammo.desc1", "nuclear_craft")).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.ammo.desc2", "nuclear_craft")).m_130940_(ChatFormatting.GRAY));
        if (AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoTypes().contains((Object)this.getType())) {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.ammo.base_damage", "nuclear_craft")).m_7220_((Component)new TextComponent(String.format(" %.2f x %d", this.getBaseDamage(), ConfigCommon.BIRD_SHOT_COUNT_MAP.get((Object)this.getType()).get()))).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.ammo.base_damage", "nuclear_craft")).m_7220_((Component)new TextComponent(String.format(" %.2f", this.getBaseDamage())).m_130940_(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.ammo.base_speed", "nuclear_craft")).m_7220_((Component)new TextComponent(String.format(" %.2f m/s", Float.valueOf(20.0f * this.getBaseSpeed()))).m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TranslatableComponent(String.format("tooltip.%s.ammo.gravity", "nuclear_craft")).m_7220_((Component)new TextComponent(String.format(" %.2f m/s^2", 400.0 * this.getGravity()))).m_130940_(ChatFormatting.GRAY));
    }
}

