/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items;

import com.song.nuclear_craft.NuclearCraft;
import com.song.nuclear_craft.blocks.BlockList;
import com.song.nuclear_craft.items.AbstractAmmo;
import com.song.nuclear_craft.items.Ammo.AmmoPossibleCombination;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.C4BombItem;
import com.song.nuclear_craft.items.DebugStick;
import com.song.nuclear_craft.items.RocketLauncher;
import com.song.nuclear_craft.items.RocketLauncherAtomicBomb;
import com.song.nuclear_craft.items.RocketLauncherHighExplosive;
import com.song.nuclear_craft.items.RocketLauncherIncendiary;
import com.song.nuclear_craft.items.RocketLauncherSmoke;
import com.song.nuclear_craft.items.RocketLauncherWaterDrop;
import com.song.nuclear_craft.items.defuse_kit.DefuseKit;
import com.song.nuclear_craft.items.defuse_kit.DiamondDefuseKit;
import com.song.nuclear_craft.items.defuse_kit.GoldDefuseKit;
import com.song.nuclear_craft.items.defuse_kit.IronDefuseKit;
import com.song.nuclear_craft.items.defuse_kit.NetheriteDefuseKit;
import com.song.nuclear_craft.items.defuse_kit.WoodDefuseKit;
import com.song.nuclear_craft.items.guns.Ak47;
import com.song.nuclear_craft.items.guns.Awp;
import com.song.nuclear_craft.items.guns.Barrett;
import com.song.nuclear_craft.items.guns.DesertEagle;
import com.song.nuclear_craft.items.guns.FN57;
import com.song.nuclear_craft.items.guns.Glock;
import com.song.nuclear_craft.items.guns.M4A4;
import com.song.nuclear_craft.items.guns.Nova;
import com.song.nuclear_craft.items.guns.P90;
import com.song.nuclear_craft.items.guns.Rocket;
import com.song.nuclear_craft.items.guns.USP;
import com.song.nuclear_craft.items.guns.XM1014;
import com.song.nuclear_craft.misc.Util;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemList {
    public static final DeferredRegister<Item> ITEMS;
    public static final RegistryObject<Item> DEBUG_STICK;
    public static final RegistryObject<Item> ATOMIC_BOMB_ROCKET;
    public static final RegistryObject<Item> INCENDIARY_ROCKET;
    public static final RegistryObject<Item> SMOKE_ROCKET;
    public static final RegistryObject<Item> HIGH_EXPLOSIVE_ROCKET;
    public static final RegistryObject<Item> WATER_DROP_ROCKET;
    public static final RegistryObject<RocketLauncher> ROCKET_LAUNCHER;
    public static final RegistryObject<RocketLauncherAtomicBomb> ROCKET_LAUNCHER_ATOMIC_BOMB;
    public static final RegistryObject<RocketLauncherSmoke> ROCKET_LAUNCHER_SMOKE;
    public static final RegistryObject<RocketLauncherIncendiary> ROCKET_LAUNCHER_INCENDIARY;
    public static final RegistryObject<RocketLauncherHighExplosive> ROCKET_LAUNCHER_HIGH_EXPLOSIVE;
    public static final RegistryObject<RocketLauncherWaterDrop> ROCKET_LAUNCHER_WATER_DROP;
    public static final Item C4_ATOMIC_BOMB;
    public static final Item C4_HIGH_EXPLOSIVE;
    public static final Item C4_INCENDIARY;
    public static final Item C4_SMOKE;
    public static final RegistryObject<Item> STATUE_OF_LIBERTY;
    public static final RegistryObject<Item> STATUE_OF_RIFLE_AMMO;
    public static final RegistryObject<Item> STATUE_OF_SHOTGUN_AMMO;
    public static final RegistryObject<Item> STATUE_OF_ROCKET;
    public static final RegistryObject<Item> STATUE_OF_EXPLOSIVE;
    public static final RegistryObject<DesertEagle> DESERT_EAGLE;
    public static final RegistryObject<Glock> GLOCK;
    public static final RegistryObject<FN57> FN57;
    public static final RegistryObject<USP> USP;
    public static final RegistryObject<Ak47> AK47;
    public static final RegistryObject<Awp> AWP;
    public static final RegistryObject<Barrett> BARRETT;
    public static final RegistryObject<M4A4> M4A4;
    public static final RegistryObject<XM1014> XM1014;
    public static final RegistryObject<Nova> NOVA;
    public static final RegistryObject<P90> P90;
    public static final RegistryObject<DefuseKit> WOOD_DEFUSE_KIT;
    public static final RegistryObject<DefuseKit> IRON_DEFUSE_KIT;
    public static final RegistryObject<DefuseKit> GOLD_DEFUSE_KIT;
    public static final RegistryObject<DefuseKit> DIAMOND_DEFUSE_KIT;
    public static final RegistryObject<DefuseKit> NETHERITE_DEFUSE_KIT;
    public static final HashMap<AmmoSize, HashMap<AmmoType, RegistryObject<AbstractAmmo>>> AMMO_REGISTRIES_TYPE;
    public static final HashMap<AmmoType, RegistryObject<AbstractAmmo>> BIRD_SHOT_MAP;

    static {
        HashMap<AmmoType, RegistryObject> tmp;
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"nuclear_craft");
        DEBUG_STICK = ITEMS.register("debug_stick", DebugStick::new);
        ATOMIC_BOMB_ROCKET = ITEMS.register("atomic_bomb_rocket", () -> new Rocket(new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP).m_41487_(1), 1));
        INCENDIARY_ROCKET = ITEMS.register("incendiary_rocket", () -> new Rocket(new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP), 1));
        SMOKE_ROCKET = ITEMS.register("smoke_rocket", () -> new Rocket(new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP), 1));
        HIGH_EXPLOSIVE_ROCKET = ITEMS.register("high_explosive_rocket", () -> new Rocket(new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP), 1));
        WATER_DROP_ROCKET = ITEMS.register("water_drop_rocket", () -> new Rocket(new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP), 1));
        ROCKET_LAUNCHER = ITEMS.register("rocket_launcher", RocketLauncher::new);
        ROCKET_LAUNCHER_ATOMIC_BOMB = ITEMS.register("rocket_launcher_atomic_bomb", RocketLauncherAtomicBomb::new);
        ROCKET_LAUNCHER_SMOKE = ITEMS.register("rocket_launcher_smoke", RocketLauncherSmoke::new);
        ROCKET_LAUNCHER_INCENDIARY = ITEMS.register("rocket_launcher_incendiary", RocketLauncherIncendiary::new);
        ROCKET_LAUNCHER_HIGH_EXPLOSIVE = ITEMS.register("rocket_launcher_high_explosive", RocketLauncherHighExplosive::new);
        ROCKET_LAUNCHER_WATER_DROP = ITEMS.register("rocket_launcher_water_drop", RocketLauncherWaterDrop::new);
        C4_ATOMIC_BOMB = new C4BombItem((Block)BlockList.C4_ATOMIC_BOMB, new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP));
        C4_HIGH_EXPLOSIVE = new C4BombItem((Block)BlockList.C4_HIGH_EXPLOSIVE, new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP));
        C4_INCENDIARY = new C4BombItem((Block)BlockList.C4_INCENDIARY, new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP));
        C4_SMOKE = new C4BombItem((Block)BlockList.C4_SMOKE, new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP));
        STATUE_OF_LIBERTY = ITEMS.register("statue_of_liberty", () -> new BlockItem((Block)BlockList.STATUE_OF_LIBERTY.get(), new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP)));
        STATUE_OF_RIFLE_AMMO = ITEMS.register("statue_of_rifle_ammo", () -> new BlockItem((Block)BlockList.STATUE_OF_RIFLE_AMMO.get(), new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP)));
        STATUE_OF_SHOTGUN_AMMO = ITEMS.register("statue_of_shotgun_ammo", () -> new BlockItem((Block)BlockList.STATUE_OF_SHOTGUN_AMMO.get(), new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP)));
        STATUE_OF_ROCKET = ITEMS.register("statue_of_rocket", () -> new BlockItem((Block)BlockList.STATUE_OF_ROCKET.get(), new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP)));
        STATUE_OF_EXPLOSIVE = ITEMS.register("statue_of_explosive", () -> new BlockItem((Block)BlockList.STATUE_OF_EXPLOSIVE.get(), new Item.Properties().m_41491_(NuclearCraft.ITEM_GROUP)));
        DESERT_EAGLE = ITEMS.register("desert_eagle", DesertEagle::new);
        GLOCK = ITEMS.register("glock", Glock::new);
        FN57 = ITEMS.register("fn57", FN57::new);
        USP = ITEMS.register("usp", USP::new);
        AK47 = ITEMS.register("ak47", Ak47::new);
        AWP = ITEMS.register("awp", Awp::new);
        BARRETT = ITEMS.register("barrett", Barrett::new);
        M4A4 = ITEMS.register("m4a4", M4A4::new);
        XM1014 = ITEMS.register("xm1014", XM1014::new);
        NOVA = ITEMS.register("nova", Nova::new);
        P90 = ITEMS.register("p90", P90::new);
        WOOD_DEFUSE_KIT = ITEMS.register("wood_defuse_kit", WoodDefuseKit::new);
        IRON_DEFUSE_KIT = ITEMS.register("iron_defuse_kit", IronDefuseKit::new);
        GOLD_DEFUSE_KIT = ITEMS.register("gold_defuse_kit", GoldDefuseKit::new);
        DIAMOND_DEFUSE_KIT = ITEMS.register("diamond_defuse_kit", DiamondDefuseKit::new);
        NETHERITE_DEFUSE_KIT = ITEMS.register("netherite_defuse_kit", NetheriteDefuseKit::new);
        AMMO_REGISTRIES_TYPE = new HashMap();
        BIRD_SHOT_MAP = new HashMap();
        for (AmmoSize ammoSize : AmmoPossibleCombination.RIFLE_AMMO.getAmmoSizes()) {
            tmp = new HashMap<AmmoType, RegistryObject>();
            for (AmmoType ammoType : AmmoPossibleCombination.RIFLE_AMMO.getAmmoTypes()) {
                tmp.put(ammoType, ITEMS.register(Util.getAmmoRegisterString(ammoSize, ammoType), () -> new AbstractAmmo(new Item.Properties().m_41491_(NuclearCraft.AMMO_ITEM_GROUP), ammoSize, ammoType)));
            }
            AMMO_REGISTRIES_TYPE.put(ammoSize, tmp);
        }
        for (AmmoSize ammoSize : AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoSizes()) {
            tmp = new HashMap();
            for (AmmoType ammoType : AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoTypes()) {
                tmp.put(ammoType, ITEMS.register(Util.getAmmoRegisterString(ammoSize, ammoType), () -> new AbstractAmmo(new Item.Properties().m_41491_(NuclearCraft.AMMO_ITEM_GROUP), ammoSize, ammoType, 1)));
            }
            AMMO_REGISTRIES_TYPE.put(ammoSize, tmp);
        }
        for (AmmoType ammoType : AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoTypes()) {
            BIRD_SHOT_MAP.put(ammoType, (RegistryObject<AbstractAmmo>)ITEMS.register("bird_shot_12_ga_" + ammoType.getRegisterString(), () -> new AbstractAmmo(new Item.Properties(), AmmoSize.SIZE_12_GA, ammoType)));
        }
        C4_ATOMIC_BOMB.setRegistryName(Objects.requireNonNull(BlockList.C4_ATOMIC_BOMB.getRegistryName()));
        C4_HIGH_EXPLOSIVE.setRegistryName(Objects.requireNonNull(BlockList.C4_HIGH_EXPLOSIVE.getRegistryName()));
        C4_INCENDIARY.setRegistryName(Objects.requireNonNull(BlockList.C4_INCENDIARY.getRegistryName()));
        C4_SMOKE.setRegistryName(Objects.requireNonNull(BlockList.C4_SMOKE.getRegistryName()));
    }
}

