/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items;

import com.song.nuclear_craft.events.ClientEventForgeSubscriber;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.network.GunLoadingPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public abstract class RocketLauncherWithAmmo
extends Item {
    private static final int MAX_AMMO = 10;
    protected int coolDown = 0;

    public RocketLauncherWithAmmo(Item.Properties properties) {
        super(properties);
    }

    protected int getMAX_AMMO() {
        return 10;
    }

    public abstract Item getBoundedAmmo();

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        this.enterCD(playerIn);
        ItemStack toBeFired = new ItemStack((ItemLike)this.getBoundedAmmo());
        toBeFired.m_41698_("Fireworks").m_128344_("Flight", (byte)127);
        ItemStack thisItemStack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            FireworkRocketEntity entity = this.getEntity(worldIn, toBeFired, (Entity)playerIn, playerIn.m_20185_(), playerIn.m_20188_() - (double)0.15f, playerIn.m_20189_(), true);
            Vec3 vec3d = playerIn.m_20154_();
            entity.m_6686_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 5.0f, 0.0f);
            worldIn.m_7967_((Entity)entity);
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (playerIn.m_7500_()) {
            return InteractionResultHolder.m_19092_((Object)thisItemStack, (boolean)worldIn.m_5776_());
        }
        return this.afterFire(worldIn, thisItemStack);
    }

    protected abstract FireworkRocketEntity getEntity(Level var1, ItemStack var2, Entity var3, double var4, double var6, double var8, boolean var10);

    protected int getAmmoCount(ItemStack itemStack) {
        CompoundTag compoundnbt = itemStack.m_41784_();
        if (!compoundnbt.m_128441_("ammo")) {
            compoundnbt.m_128405_("ammo", this.getMAX_AMMO());
        }
        return compoundnbt.m_128451_("ammo");
    }

    protected void addAmmoCount(ItemStack itemStack, int n) {
        CompoundTag compoundnbt = itemStack.m_41784_();
        assert (compoundnbt.m_128441_("ammo"));
        compoundnbt.m_128405_("ammo", n + compoundnbt.m_128451_("ammo"));
    }

    public void clearAmmo(ItemStack itemStack) {
        this.addAmmoCount(itemStack, -this.getAmmoCount(itemStack));
    }

    protected InteractionResultHolder<ItemStack> afterFire(Level worldIn, ItemStack thisItemStack) {
        CompoundTag compoundnbt = thisItemStack.m_41784_();
        if (!compoundnbt.m_128441_("ammo")) {
            compoundnbt.m_128405_("ammo", this.getMAX_AMMO());
        }
        if (!worldIn.f_46443_) {
            int n_ammo = compoundnbt.m_128451_("ammo");
            compoundnbt.m_128405_("ammo", --n_ammo);
        }
        if (compoundnbt.m_128451_("ammo") <= 0) {
            return InteractionResultHolder.m_19092_((Object)new ItemStack((ItemLike)ItemList.ROCKET_LAUNCHER.get()), (boolean)worldIn.m_5776_());
        }
        return InteractionResultHolder.m_19092_((Object)thisItemStack, (boolean)worldIn.m_5776_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int n_ammo = this.getAmmoCount(stack);
        tooltip.add((Component)new TranslatableComponent(String.format("item.%s.rocket_launcher.ammo_left", "nuclear_craft")).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TextComponent("" + n_ammo).m_130940_(ChatFormatting.GOLD));
    }

    public void addAmmo(ItemStack ammo, ItemStack rocket, int itemSlot, Entity entityIn) {
        int n_ammo;
        if (this.getBoundedAmmo() != null && ammo.m_41720_().getRegistryName().equals((Object)this.getBoundedAmmo().getRegistryName()) && (n_ammo = this.getAmmoCount(rocket)) < this.getMAX_AMMO()) {
            int n_loaded = Math.min(this.getMAX_AMMO() - n_ammo, ammo.m_41613_());
            ammo.m_41774_(n_loaded);
            this.addAmmoCount(rocket, n_loaded);
            BlockPos pos = entityIn.m_142538_();
            NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)20.0, (ResourceKey)entityIn.f_19853_.m_46472_())), (Object)new SoundPacket(pos, "rocket_load"));
            ((Player)entityIn).m_36335_().m_41524_(rocket.m_41720_(), 20);
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (isSelected && worldIn.f_46443_ && ClientEventForgeSubscriber.gunReload.m_90859_() && entityIn instanceof Player) {
            NuclearCraftPacketHandler.KEY_BIND.sendToServer((Object)new GunLoadingPacket(itemSlot));
        }
    }

    protected void enterCD(Player playerEntity) {
        playerEntity.m_36335_().m_41524_((Item)this, this.coolDown);
    }
}

