/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items.guns;

import com.song.nuclear_craft.entities.AbstractAmmoEntity;
import com.song.nuclear_craft.entities.AmmoEntities.IAmmoEntityFactory;
import com.song.nuclear_craft.events.ClientEventForgeSubscriber;
import com.song.nuclear_craft.items.AbstractAmmo;
import com.song.nuclear_craft.items.Ammo.AmmoPossibleCombination;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.ItemList;
import com.song.nuclear_craft.items.RocketLauncherWithAmmo;
import com.song.nuclear_craft.network.GunLoadingPacket;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public abstract class AbstractGunItem
extends Item {
    protected int coolDown;
    protected Random random = new Random();

    public AbstractGunItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack heldItemStack = playerIn.m_21120_(handIn);
        if (heldItemStack.m_41720_() instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)heldItemStack.m_41720_();
            if (!worldIn.f_46443_ && AbstractGunItem.hasAmmo(heldItemStack)) {
                AmmoType ammoType = AbstractGunItem.getAmmoType(heldItemStack);
                assert (ammoType != null);
                AmmoSize ammoSize = this.compatibleSize();
                if (gunItem.getCoolDown() > 0) {
                    playerIn.m_36335_().m_41524_(heldItemStack.m_41720_(), gunItem.getCoolDown());
                }
                AbstractAmmo ammoItem = gunItem.getAmmoItem(ammoType, ammoSize);
                ItemStack toBeFired = new ItemStack((ItemLike)ammoItem);
                Vec3 lookVec = playerIn.m_20154_();
                for (int i = 0; i < this.getBirdShotCount(ammoType); ++i) {
                    AbstractAmmoEntity entity = this.getAmmoEntity(gunItem, playerIn, lookVec, toBeFired, worldIn, ammoItem, ammoType, ammoSize);
                    entity.m_6686_(lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_, ammoItem.getBaseSpeed() * this.getSpeedModifier() * (1.0f + 0.01f * this.random.nextFloat()), this.getInaccuracy(worldIn, playerIn));
                    entity.m_8119_();
                    worldIn.m_7967_((Entity)entity);
                }
                BlockPos playerPos = playerIn.m_142538_();
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)playerPos.m_123341_(), (double)playerPos.m_123342_(), (double)playerPos.m_123343_(), (double)this.getGunSoundDist(), (ResourceKey)playerIn.f_19853_.m_46472_())), (Object)new SoundPacket(playerPos, this.getShootActionString()));
                AbstractGunItem.shrinkAmmoNBT(heldItemStack);
                return InteractionResultHolder.m_19092_((Object)heldItemStack, (boolean)worldIn.m_5776_());
            }
            if (!worldIn.f_46443_) {
                BlockPos pos = playerIn.m_142538_();
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)4.0, (ResourceKey)playerIn.f_19853_.m_46472_())), (Object)new SoundPacket(pos, "no_ammo"));
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    protected AbstractAmmoEntity getAmmoEntity(AbstractGunItem gunItem, Player playerIn, Vec3 lookVec, ItemStack toBeFired, Level worldIn, AbstractAmmo ammoItem, AmmoType ammoType, AmmoSize ammoSize) {
        AbstractAmmoEntity entity = gunItem.getAmmoEntity(playerIn.m_20185_() + lookVec.f_82479_ * 0.1, playerIn.m_20188_() - (double)0.15f + lookVec.f_82480_ * 0.1, playerIn.m_20189_() + lookVec.f_82481_ * 0.1, worldIn, toBeFired, playerIn, ammoType, ammoSize);
        entity.m_20225_(true);
        entity.m_20242_(true);
        entity.setGravity(ammoItem.getGravity());
        entity.setBaseDamage(this.getDamageModifier() * entity.getBaseDamage());
        return entity;
    }

    protected float getInaccuracy(Level world, Player playerEntity) {
        return 0.0f;
    }

    protected int getBirdShotCount(AmmoType ammoType) {
        return 1;
    }

    protected double getGunSoundDist() {
        return 20.0;
    }

    public static boolean hasAmmo(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41737_("ammo");
        if (nbt == null) {
            return false;
        }
        int nAmmo = nbt.m_128451_("count");
        if (nAmmo > 0) {
            return true;
        }
        AbstractGunItem.clearAmmoNBT(itemStack);
        return false;
    }

    public static void clearAmmoNBT(ItemStack itemStack) {
        itemStack.m_41749_("ammo");
    }

    public static int getAmmoCount(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41737_("ammo");
        if (nbt == null) {
            return 0;
        }
        int nAmmo = nbt.m_128451_("count");
        if (nAmmo > 0) {
            return nAmmo;
        }
        AbstractGunItem.clearAmmoNBT(itemStack);
        return 0;
    }

    public static void addAmmoNBT(ItemStack itemStack, int n, String type) {
        CompoundTag nbt = itemStack.m_41698_("ammo");
        nbt.m_128405_("count", nbt.m_128451_("count") + n);
        nbt.m_128359_("type", type);
    }

    public static void shrinkAmmoNBT(ItemStack itemStack) {
        int nAmmo = AbstractGunItem.getAmmoCount(itemStack);
        int nAmmoAfter = nAmmo - 1;
        if (nAmmoAfter <= 0) {
            AbstractGunItem.clearAmmoNBT(itemStack);
        } else {
            CompoundTag nbt = itemStack.m_41698_("ammo");
            nbt.m_128405_("count", nAmmoAfter);
        }
    }

    public static AmmoType getAmmoType(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41737_("ammo");
        if (nbt == null) {
            return null;
        }
        return AmmoType.valueOf(nbt.m_128461_("type"));
    }

    public static String getAmmoShowType(ItemStack itemStack) {
        AmmoType type = AbstractGunItem.getAmmoType(itemStack);
        return type == null ? "none" : type.getDescription();
    }

    public AbstractAmmo getAmmoItem(AmmoType ammoType, AmmoSize ammoSize) {
        if (AmmoPossibleCombination.SHOTGUN_AMMO.getAmmoTypes().contains((Object)ammoType)) {
            return AmmoType.getBirdShotFromType(ammoType);
        }
        return (AbstractAmmo)ItemList.AMMO_REGISTRIES_TYPE.get((Object)ammoSize).get((Object)ammoType).get();
    }

    public abstract int getCoolDown();

    public AbstractAmmoEntity getAmmoEntity(double x, double y, double z, Level world, ItemStack toBeFired, Player shooter, AmmoType ammoType, AmmoSize ammoSize) {
        return IAmmoEntityFactory.getAmmoEntityFactory(ammoType).create(x, y, z, world, toBeFired, shooter);
    }

    protected int getAmmoCountPerLoad() {
        return -1;
    }

    public void addAmmo(ItemStack offhand, ItemStack mainHand, int slot, Player entity) {
        ItemStack ammo = this.findAmmo(offhand, mainHand, slot, entity);
        if (ammo != null) {
            AbstractAmmo ammoItem = (AbstractAmmo)ammo.m_41720_();
            if (AbstractGunItem.hasAmmo(mainHand) && ammoItem.getType() == AbstractGunItem.getAmmoType(mainHand) || !AbstractGunItem.hasAmmo(mainHand)) {
                int n_load = 0;
                n_load = this.getAmmoCountPerLoad() > 0 ? Math.min(this.getAmmoCountPerLoad(), this.maxAmmo() - AbstractGunItem.getAmmoCount(mainHand)) : Math.min(ammo.m_41613_(), this.maxAmmo() - AbstractGunItem.getAmmoCount(mainHand));
                if (n_load > 0) {
                    ammo.m_41774_(n_load);
                    AbstractGunItem.addAmmoNBT(mainHand, n_load, ammoItem.getType().name());
                    entity.m_36335_().m_41524_(mainHand.m_41720_(), this.getLoadTime());
                    if (!entity.f_19853_.f_46443_) {
                        BlockPos pos = entity.m_142538_();
                        NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)10.0, (ResourceKey)entity.f_19853_.m_46472_())), (Object)new SoundPacket(pos, this.getReloadSound()));
                    }
                }
            }
        }
    }

    public ItemStack findAmmo(ItemStack offhand, ItemStack mainHand, int slot, Player entity) {
        if (offhand.m_41720_() instanceof AbstractAmmo && ((AbstractAmmo)offhand.m_41720_()).getSize() == this.compatibleSize()) {
            return offhand;
        }
        for (ItemStack stack : entity.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof AbstractAmmo) || ((AbstractAmmo)stack.m_41720_()).getSize() != this.compatibleSize()) continue;
            return stack;
        }
        return null;
    }

    public abstract String getShootActionString();

    public abstract int maxAmmo();

    public abstract int getLoadTime();

    @Nonnull
    public abstract AmmoSize compatibleSize();

    public abstract float getSpeedModifier();

    public abstract double getDamageModifier();

    public abstract String getReloadSound();

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (isSelected && worldIn.f_46443_) {
            if (ClientEventForgeSubscriber.gunReload.m_90859_() && entityIn instanceof Player) {
                NuclearCraftPacketHandler.KEY_BIND.sendToServer((Object)new GunLoadingPacket(itemSlot));
            }
            Minecraft.m_91087_().f_91065_.m_93063_((Component)new TranslatableComponent(String.format("item.%s.guns.ammo_left", "nuclear_craft")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + AbstractGunItem.getAmmoCount(stack)).m_130940_(ChatFormatting.GOLD)), false);
        }
    }

    public static void tryLoadAmmo(ServerLevel world, Player entity, int itemSlot) {
        ItemStack itemStackMain = entity.m_21205_();
        if (itemStackMain.m_41720_() instanceof AbstractGunItem && !entity.m_36335_().m_41519_(itemStackMain.m_41720_())) {
            ItemStack itemStackOff = entity.m_21206_();
            ((AbstractGunItem)itemStackMain.m_41720_()).addAmmo(itemStackOff, itemStackMain, itemSlot, entity);
        } else if (itemStackMain.m_41720_() instanceof RocketLauncherWithAmmo) {
            ItemStack itemStackOff = entity.m_21206_();
            ((RocketLauncherWithAmmo)itemStackMain.m_41720_()).addAmmo(itemStackOff, itemStackMain, itemSlot, (Entity)entity);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (AbstractGunItem.hasAmmo(stack)) {
            int n_ammo = AbstractGunItem.getAmmoCount(stack);
            tooltip.add((Component)new TranslatableComponent(String.format("item.%s.guns.ammo_left", "nuclear_craft")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + n_ammo).m_130940_(ChatFormatting.GOLD)));
            tooltip.add((Component)new TranslatableComponent(String.format("item.%s.guns.ammo_type", "nuclear_craft")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(Objects.requireNonNull(AbstractGunItem.getAmmoType(stack)).getDescription()).m_130940_(ChatFormatting.GOLD)));
        }
        tooltip.add((Component)new TranslatableComponent(String.format("item.%s.guns.compatible_ammo_size", "nuclear_craft")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + this.compatibleSize())));
        tooltip.add((Component)new TranslatableComponent(String.format("item.%s.guns.damage_modifier", "nuclear_craft")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.0f", 100.0 * this.getDamageModifier()) + "%")));
        tooltip.add((Component)new TranslatableComponent(String.format("item.%s.guns.speed_modifier", "nuclear_craft")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.0f", Float.valueOf(100.0f * this.getSpeedModifier())) + "%")));
        if (this.canUseScope()) {
            tooltip.add((Component)new TranslatableComponent(String.format("item.%s.guns.use_scope", "nuclear_craft")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" Z")));
        }
    }

    public boolean canUseScope() {
        return false;
    }
}

