/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.items.guns;

import com.song.nuclear_craft.entities.AbstractAmmoEntity;
import com.song.nuclear_craft.items.AbstractAmmo;
import com.song.nuclear_craft.items.Ammo.AmmoSize;
import com.song.nuclear_craft.items.Ammo.AmmoType;
import com.song.nuclear_craft.items.guns.AbstractGunItem;
import com.song.nuclear_craft.network.NuclearCraftPacketHandler;
import com.song.nuclear_craft.network.SoundPacket;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public abstract class AbstractMachineGunItem
extends AbstractGunItem {
    public AbstractMachineGunItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack heldItemStack = playerIn.m_21120_(handIn);
        if (heldItemStack.m_41720_() instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)heldItemStack.m_41720_();
            if (!worldIn.f_46443_ && AbstractMachineGunItem.hasAmmo(heldItemStack)) {
                AmmoType ammoType = AbstractMachineGunItem.getAmmoType(heldItemStack);
                assert (ammoType != null);
                AmmoSize ammoSize = this.compatibleSize();
                if (gunItem.getCoolDown() > 0) {
                    playerIn.m_36335_().m_41524_(heldItemStack.m_41720_(), gunItem.getCoolDown());
                }
                AbstractAmmo ammoItem = gunItem.getAmmoItem(ammoType, ammoSize);
                ItemStack toBeFired = new ItemStack((ItemLike)ammoItem);
                Vec3 lookVec = playerIn.m_20154_();
                BlockPos playerPos = playerIn.m_142538_();
                for (int i = 0; i < this.getNumShoots(); ++i) {
                    AbstractAmmoEntity entity = this.getAmmoEntity(gunItem, playerIn, lookVec, toBeFired, worldIn, ammoItem, ammoType, ammoSize);
                    entity.m_6686_(lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_, ammoItem.getBaseSpeed() * this.getSpeedModifier() * (1.0f + 0.01f * this.random.nextFloat()), this.getInaccuracy(worldIn, playerIn));
                    entity.m_8119_();
                    worldIn.m_7967_((Entity)entity);
                    AbstractMachineGunItem.shrinkAmmoNBT(heldItemStack);
                }
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)playerPos.m_123341_(), (double)playerPos.m_123342_(), (double)playerPos.m_123343_(), (double)this.getGunSoundDist(), (ResourceKey)playerIn.f_19853_.m_46472_())), (Object)new SoundPacket(playerPos, this.getShootActionString()));
                return InteractionResultHolder.m_19092_((Object)heldItemStack, (boolean)worldIn.m_5776_());
            }
            if (!worldIn.f_46443_) {
                BlockPos pos = playerIn.m_142538_();
                NuclearCraftPacketHandler.C4_SETTING_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)4.0, (ResourceKey)playerIn.f_19853_.m_46472_())), (Object)new SoundPacket(pos, "no_ammo"));
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    protected abstract int getNumShoots();
}

