/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.misc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class NukeExplosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private final boolean causesFire;
    private final Explosion.BlockInteraction mode;
    private final Random random = new Random();
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity exploder;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<Player, Vec3> playerKnockbackMap = Maps.newHashMap();
    private final Vec3 position;

    public NukeExplosion(Level worldIn, @Nullable Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        super(worldIn, entityIn, null, null, x, y, z, size, false, Explosion.BlockInteraction.DESTROY);
        this.world = worldIn;
        this.exploder = entityIn;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.causesFire = false;
        this.mode = Explosion.BlockInteraction.DESTROY;
        this.position = new Vec3(this.x, this.y, this.z);
        this.affectedBlockPositions.addAll(affectedPositions);
    }

    public void addAffected(BlockPos blockPos) {
        this.affectedBlockPositions.add(blockPos);
    }

    public void m_46061_() {
        float f2 = this.size * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.world.m_45933_(this.exploder, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.world, (Explosion)this, (List)list, (double)f2);
        Vec3 vector3d = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || !((d12 = (double)(Mth.m_14116_((float)((float)entity.m_20238_(vector3d))) / f2)) <= 1.0) || (d13 = (double)Mth.m_14116_((float)((float)((d5 = entity.m_20185_() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = NukeExplosion.m_46064_((Vec3)vector3d, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(this.m_46077_(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (playerentity = (Player)entity).m_5833_() || playerentity.m_7500_() && playerentity.m_150110_().f_35935_) continue;
            this.playerKnockbackMap.put(playerentity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void m_46075_(boolean spawnParticles) {
        boolean flag;
        if (this.world.f_46443_) {
            this.world.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.world.f_46441_.nextFloat() - this.world.f_46441_.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Explosion.BlockInteraction.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.affectedBlockPositions, this.world.f_46441_);
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState blockstate = this.world.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.world.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.world, blockpos, (Explosion)this) && this.world instanceof ServerLevel) {
                    BlockEntity tileentity = blockstate.m_155947_() ? this.world.m_7702_(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.world).m_78977_(this.world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78984_(LootContextParams.f_81462_, (Object)tileentity).m_78984_(LootContextParams.f_81455_, (Object)this.exploder);
                    if (this.mode == Explosion.BlockInteraction.DESTROY) {
                        lootcontext$builder.m_78972_(LootContextParams.f_81464_, (Object)Float.valueOf(this.size));
                    }
                    blockstate.m_60724_(lootcontext$builder).forEach(p_229977_2_ -> NukeExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, blockpos1));
                }
                blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
                this.world.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.causesFire) {
            for (BlockPos blockpos2 : this.affectedBlockPositions) {
                if (this.random.nextInt(3) != 0 || !this.world.m_8055_(blockpos2).m_60795_() || !this.world.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.world, blockpos2.m_7495_())) continue;
                this.world.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.world, (BlockPos)blockpos2));
            }
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> p_229976_0_, ItemStack p_229976_1_, BlockPos p_229976_2_) {
        int i = p_229976_0_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_229976_0_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)p_229976_1_)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)p_229976_1_, (int)16);
            p_229976_0_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_229976_1_.m_41619_()) continue;
            return;
        }
        p_229976_0_.add((Object)Pair.of((Object)p_229976_1_, (Object)p_229976_2_));
    }
}

