/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.blocks.tileentity.C4BombTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class C4BombSettingPacket {
    public double x;
    public double y;
    public double z;
    public String action;

    public C4BombSettingPacket(BlockPos pos, String action) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.action = action;
    }

    public C4BombSettingPacket(FriendlyByteBuf packetBuffer) {
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
        this.action = packetBuffer.m_130136_(Short.MAX_VALUE);
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.m_130070_(this.action);
    }

    public static void handle(C4BombSettingPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            PacketListener handler = context.getNetworkManager().m_129538_();
            if (handler instanceof ServerGamePacketListenerImpl) {
                ServerLevel world = (ServerLevel)((ServerGamePacketListenerImpl)handler).f_9743_.f_19853_;
                BlockEntity entity = world.m_7702_(new BlockPos(packet.x, packet.y, packet.z));
                if (!(entity instanceof C4BombTileEntity)) {
                    throw new IllegalArgumentException("entity should be C4bomb, but not: " + entity);
                }
                switch (packet.action.split("_")[0]) {
                    case "add": {
                        ((C4BombTileEntity)entity).addNum(Integer.parseInt(packet.action.split("_")[1]));
                        break;
                    }
                    case "delete": {
                        ((C4BombTileEntity)entity).delete();
                        break;
                    }
                    case "activate": {
                        ((C4BombTileEntity)entity).activate();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("not recognized argument: " + packet.action);
                    }
                }
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }
}

