/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.blocks.tileentity.C4BombTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class C4BombSynPacket {
    public double x;
    public double y;
    public double z;
    public String inputPanel;
    public int fuse_age;
    public int explode_time;
    public boolean is_active;

    public C4BombSynPacket(BlockPos pos, String inputPanel, int fuse_age, int explode_time, boolean is_active) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.inputPanel = inputPanel;
        this.fuse_age = fuse_age;
        this.explode_time = explode_time;
        this.is_active = is_active;
    }

    public C4BombSynPacket(FriendlyByteBuf packetBuffer) {
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
        this.inputPanel = packetBuffer.m_130277_();
        this.fuse_age = packetBuffer.readInt();
        this.explode_time = packetBuffer.readInt();
        this.is_active = packetBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.m_130070_(this.inputPanel);
        packetBuffer.writeInt(this.fuse_age);
        packetBuffer.writeInt(this.explode_time);
        packetBuffer.writeBoolean(this.is_active);
    }

    public static void handle(C4BombSynPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BlockEntity entity = Minecraft.m_91087_().f_91073_.m_7702_(new BlockPos(packet.x, packet.y, packet.z));
            if (entity instanceof C4BombTileEntity) {
                ((C4BombTileEntity)entity).setAttr(packet.inputPanel, packet.fuse_age, packet.explode_time, packet.is_active);
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

