/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.items.guns.AbstractGunItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class GunLoadingPacket {
    public int slot;

    public GunLoadingPacket(int slot) {
        this.slot = slot;
    }

    public GunLoadingPacket(FriendlyByteBuf packetBuffer) {
        this.slot = packetBuffer.readInt();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.slot);
    }

    public static void handle(GunLoadingPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            PacketListener handler = context.getNetworkManager().m_129538_();
            if (handler instanceof ServerGamePacketListenerImpl) {
                ServerLevel world = (ServerLevel)((ServerGamePacketListenerImpl)handler).f_9743_.f_19853_;
                ServerPlayer playerEntity = ((ServerGamePacketListenerImpl)handler).f_9743_;
                AbstractGunItem.tryLoadAmmo(world, (Player)playerEntity, packet.slot);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

