/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.entities.ExplosionUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MySExplosionPacket {
    public double radius;
    public double x;
    public double y;
    public double z;

    public MySExplosionPacket(double radius, double x, double y, double z) {
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MySExplosionPacket(FriendlyByteBuf packetBuffer) {
        this.radius = packetBuffer.readDouble();
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeDouble(this.radius);
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
    }

    public static void handle(MySExplosionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ExplosionUtils.mushroomCloud(packet.x, packet.y, packet.z, packet.radius / 2.0)));
        ctx.get().setPacketHandled(true);
    }
}

