/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.network;

import com.song.nuclear_craft.entities.rocket_entities.SmokeRocketEntity;
import com.song.nuclear_craft.particles.ParticleRegister;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ParticlePacket {
    public double x;
    public double y;
    public double z;
    public String action;

    public ParticlePacket(double x, double y, double z, String action) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.action = action;
    }

    public ParticlePacket(FriendlyByteBuf packetBuffer) {
        this.x = packetBuffer.readDouble();
        this.y = packetBuffer.readDouble();
        this.z = packetBuffer.readDouble();
        this.action = packetBuffer.m_130277_();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeDouble(this.x);
        packetBuffer.writeDouble(this.y);
        packetBuffer.writeDouble(this.z);
        packetBuffer.m_130070_(this.action);
    }

    public static void handle(ParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (packet.action) {
                case "smoke_bomb": {
                    SmokeRocketEntity.generateSmoke(packet.x, packet.y, packet.z);
                    break;
                }
                case "nuke_core": {
                    if (Minecraft.m_91087_().f_91073_ == null) break;
                    Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)ParticleRegister.EXPLODE_CORE.get(), packet.x, packet.y, packet.z, 0.0, 0.0, 0.0);
                    break;
                }
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

