/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.particles;

import com.song.nuclear_craft.entities.ExplosionUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BigSmokeParticle
extends TextureSheetParticle {
    protected BigSmokeParticle(ClientLevel world, double x, double y, double z) {
        this(world, x, y, z, 0.0, 0.0, 0.0);
    }

    protected BigSmokeParticle(ClientLevel world, double x, double y, double z, double x_speed, double y_speed, double z_speed) {
        super(world, x, y, z, x_speed, y_speed, z_speed);
    }

    protected BigSmokeParticle(ClientLevel world, double x, double y, double z, double x_speed, double y_speed, double z_speed, int age, int maxAge, float avg_scale) {
        super(world, x, y, z, x_speed, y_speed, z_speed);
        this.f_107224_ = age;
        this.f_107225_ = maxAge;
        this.f_107663_ = avg_scale * (4.5f + new Random().nextFloat()) / 5.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public static class BigSmokeFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet iAnimatedSprite;
        private static final Random random = new Random();

        public BigSmokeFactory(SpriteSet iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BigSmokeParticle bigParticle = new BigSmokeParticle(worldIn, x, y + 0.5, z, xSpeed, ySpeed, zSpeed, 0, 700 + (int)(300.0f * random.nextFloat()), 4.0f);
            bigParticle.m_108335_(this.iAnimatedSprite);
            bigParticle.m_107253_(1.0f, 1.0f, 1.0f);
            return bigParticle;
        }
    }

    public static class NukeParticleFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet iAnimatedSprite;

        public NukeParticleFactory(SpriteSet iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BigSmokeParticle nukeParticle = new BigSmokeParticle(worldIn, x, y + 0.5, z, 0.0, 0.07, 0.0, 0, 100, 4.0f * ExplosionUtils.NUKE_RADIUS / 80.0f);
            nukeParticle.m_108335_(this.iAnimatedSprite);
            nukeParticle.m_107253_(1.0f, 1.0f, 1.0f);
            return nukeParticle;
        }
    }
}

