/*
 * Decompiled with CFR 0.152.
 */
package com.song.nuclear_craft.particles;

import com.song.nuclear_craft.entities.NukeExplosionHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class RestrictedSmokeParticle
extends TextureSheetParticle {
    private double yLim;
    private double xLim;
    private double xInit;
    private double yInit;
    private double zInit;
    private double xMotionInit;
    private double yMotionInit;
    private double zMotionInit;
    private boolean canChangeColor = false;

    protected RestrictedSmokeParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected RestrictedSmokeParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, double xLim, double yLim, double scale, boolean canChangeColor) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.xInit = x;
        this.yInit = y;
        this.zInit = z;
        this.xLim = xLim;
        this.yLim = yLim;
        this.m_6569_((float)scale);
        this.f_107225_ = 3000;
        this.f_107226_ = 0.0f;
        this.xMotionInit = motionX;
        this.yMotionInit = motionY;
        this.zMotionInit = motionZ;
        this.canChangeColor = canChangeColor;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107213_ - this.yInit < this.yLim) {
            this.f_107215_ = this.xMotionInit;
            this.f_107216_ = this.yMotionInit;
            this.f_107217_ = this.zMotionInit;
        } else {
            this.m_107274_();
        }
        if (this.canChangeColor) {
            float factor = 480.0f;
            if ((float)this.f_107224_ > factor) {
                this.m_107253_(1.0f, 1.0f, 1.0f);
            } else {
                this.m_107253_(1.0f, (float)this.f_107224_ / 480.0f, (float)this.f_107224_ / 480.0f);
            }
        }
        if ((this.f_107212_ - this.xInit) * (this.f_107212_ - this.xInit) + (this.f_107214_ - this.zInit) * (this.f_107214_ - this.zInit) > this.xLim * this.xLim) {
            this.m_107274_();
        }
    }

    public int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public static class RestrictedHeightFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet iAnimatedSprite;

        public RestrictedHeightFactory(SpriteSet iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float radius = NukeExplosionHandler.getBlastRadius();
            RestrictedSmokeParticle nukeParticle = new RestrictedSmokeParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, radius, 2.0f * radius, radius / 3.0f, true);
            nukeParticle.m_108335_(this.iAnimatedSprite);
            nukeParticle.m_107253_(1.0f, 1.0f, 1.0f);
            return nukeParticle;
        }
    }

    public static class MushroomFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet iAnimatedSprite;

        public MushroomFactory(SpriteSet iAnimatedSprite) {
            this.iAnimatedSprite = iAnimatedSprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            float radius = NukeExplosionHandler.getBlastRadius();
            RestrictedSmokeParticle nukeParticle = new RestrictedSmokeParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, radius, 2.0f * radius, radius / 3.0f, false);
            nukeParticle.m_108335_(this.iAnimatedSprite);
            nukeParticle.m_107253_(1.0f, 1.0f, 1.0f);
            return nukeParticle;
        }
    }
}

