/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.api.common.data;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.util.TileEntityUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class MachineReference
implements INBTSerializable<CompoundNBT> {
    public GlobalBlockPos globalPos;
    public ResourceLocation registryName;
    public boolean chunkLoaded;
    public Direction insertFacing = Direction.UP;
    public Direction extractFacing = Direction.DOWN;
    public String customName = null;
    protected ItemStack cachedItemStack = ItemStack.field_190927_a;
    protected Item cachedItem = null;
    protected Block cachedBlock = null;

    public MachineReference() {
    }

    public MachineReference(BlockPos pos, RegistryKey<World> dimensionKey, ResourceLocation registryName, boolean chunkLoaded) {
        this(new GlobalBlockPos(pos, dimensionKey), registryName, chunkLoaded);
    }

    public MachineReference(GlobalBlockPos globalPos, ResourceLocation registryName, boolean chunkLoaded) {
        this.globalPos = globalPos;
        this.registryName = registryName;
        this.chunkLoaded = chunkLoaded;
    }

    public Block getBlock() {
        if (this.cachedBlock == null) {
            this.cachedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.registryName);
        }
        return this.cachedBlock;
    }

    public Item getItem() {
        if (this.cachedItem == null) {
            this.cachedItem = (Item)ForgeRegistries.ITEMS.getValue(this.registryName);
        }
        return this.cachedItem;
    }

    public ItemStack getItemStack() {
        if (this.cachedItemStack.func_190926_b()) {
            this.cachedItemStack = new ItemStack((IItemProvider)this.getItem());
        }
        return this.cachedItemStack;
    }

    public CompoundNBT serializeNBT() {
        return this.write(new CompoundNBT());
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.read(nbt);
    }

    public static MachineReference from(TileEntity tileEntity) {
        GlobalBlockPos pos = GlobalBlockPos.from(tileEntity);
        BlockState state = tileEntity.func_145831_w().func_180495_p(pos.getPos());
        ItemStack item = state.func_177230_c().func_185473_a((IBlockReader)tileEntity.func_145831_w(), pos.getPos(), state);
        boolean isLoaded = tileEntity.func_145831_w().func_175667_e(pos.getPos());
        return new MachineReference(pos, item.func_77973_b().getRegistryName(), isLoaded);
    }

    public static MachineReference from(CompoundNBT compound) {
        MachineReference reference = new MachineReference();
        reference.deserializeNBT(compound);
        return reference;
    }

    public static MachineReference from(PacketBuffer buf) {
        MachineReference reference = new MachineReference();
        reference.decode(buf);
        return reference;
    }

    public CompoundNBT write(CompoundNBT compound) {
        if (this.globalPos != null) {
            compound.func_218657_a("globalPos", (INBT)this.globalPos.serializeNBT());
        }
        if (this.registryName != null) {
            compound.func_74778_a("registryName", this.registryName.toString());
        }
        if (!StringUtils.isBlank((CharSequence)this.customName)) {
            compound.func_74778_a("customName", this.customName);
        }
        compound.func_74757_a("isChunkLoaded", this.chunkLoaded);
        compound.func_74774_a("insertFacing", (byte)this.insertFacing.func_176745_a());
        compound.func_74774_a("extractFacing", (byte)this.extractFacing.func_176745_a());
        return compound;
    }

    public void read(CompoundNBT compound) {
        if (compound.func_74764_b("globalPos")) {
            this.globalPos = GlobalBlockPos.from(compound.func_74775_l("globalPos"));
        }
        if (compound.func_74764_b("registryName")) {
            this.registryName = new ResourceLocation(compound.func_74779_i("registryName"));
        }
        if (compound.func_74764_b("customName")) {
            this.customName = compound.func_74779_i("customName");
        }
        this.chunkLoaded = compound.func_74767_n("isChunkLoaded");
        this.insertFacing = Direction.func_82600_a((int)compound.func_74762_e("insertFacing"));
        this.extractFacing = Direction.func_82600_a((int)compound.func_74762_e("extractFacing"));
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.write(new CompoundNBT()));
    }

    public void decode(PacketBuffer buf) {
        this.deserializeNBT(buf.func_150793_b());
    }

    public TileEntity getTileEntity(World world) {
        return TileEntityUtil.get(world, this.globalPos);
    }
}

