/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.controls;

import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class MachineSlotWidget {
    protected int x;
    protected int y;
    protected int guiLeft;
    protected int guiTop;
    protected Minecraft minecraft;
    protected IStorageControllerGuiContainer parent;
    protected MachineReference machine;
    protected FontRenderer fontRenderer;
    protected int slotHighlightColor;

    public MachineSlotWidget(IStorageControllerGuiContainer parent, @Nonnull MachineReference machine, int x, int y, int guiLeft, int guiTop) {
        this.x = x;
        this.y = y;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.parent = parent;
        this.minecraft = Minecraft.func_71410_x();
        this.machine = machine;
        this.fontRenderer = this.parent.getFontRenderer();
        this.slotHighlightColor = new Color(255, 255, 255, 128).getRGB();
    }

    public MachineReference getMachine() {
        return this.machine;
    }

    public void setMachine(MachineReference machine) {
        this.machine = machine;
    }

    public boolean isMouseOverSlot(double mouseX, double mouseY) {
        return this.parent.isPointInRegionController(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(MatrixStack matrixStack, int mx, int my) {
        RenderSystem.pushMatrix();
        this.minecraft.func_175599_af().func_180450_b(this.machine.getItemStack(), this.x, this.y);
        if (this.isMouseOverSlot(mx, my)) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.parent.drawGradientRect(matrixStack, this.x, this.y, this.x + 16, this.y + 16, this.slotHighlightColor, this.slotHighlightColor);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        RenderSystem.popMatrix();
    }

    public void drawTooltip(MatrixStack matrixStack, int mx, int my) {
        if (this.isMouseOverSlot(mx, my)) {
            this.parent.renderToolTip(matrixStack, this.machine, mx, my);
        }
    }
}

