/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.storage;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGui;
import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.api.common.data.StorageControllerGuiMode;
import com.github.klikli_dev.occultism.client.gui.controls.ItemSlotWidget;
import com.github.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.github.klikli_dev.occultism.client.gui.controls.MachineSlotWidget;
import com.github.klikli_dev.occultism.client.gui.controls.SizedImageButton;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.github.klikli_dev.occultism.integration.jei.JeiAccess;
import com.github.klikli_dev.occultism.integration.jei.JeiSettings;
import com.github.klikli_dev.occultism.network.MessageClearCraftingMatrix;
import com.github.klikli_dev.occultism.network.MessageInsertMouseHeldItem;
import com.github.klikli_dev.occultism.network.MessageRequestOrder;
import com.github.klikli_dev.occultism.network.MessageRequestStacks;
import com.github.klikli_dev.occultism.network.MessageSortItems;
import com.github.klikli_dev.occultism.network.MessageTakeItem;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.TextUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class StorageControllerGuiBase<T extends StorageControllerContainerBase>
extends ContainerScreen<T>
implements IStorageControllerGui,
IStorageControllerGuiContainer,
IInventoryChangedListener {
    public static final int ORDER_AREA_OFFSET = 48;
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("occultism", "textures/gui/storage_controller_droparea.png");
    protected static final ResourceLocation BUTTONS = new ResourceLocation("occultism", "textures/gui/buttons.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.storage_controller";
    public List<ItemStack> stacks;
    public List<MachineReference> linkedMachines;
    public IStorageControllerContainer storageControllerContainer;
    public int usedSlots;
    public int maxSlots;
    public StorageControllerGuiMode guiMode = StorageControllerGuiMode.INVENTORY;
    protected ItemStack stackUnderMouse = ItemStack.field_190927_a;
    protected TextFieldWidget searchBar;
    protected List<ItemSlotWidget> itemSlots = new ArrayList<ItemSlotWidget>();
    protected List<MachineSlotWidget> machineSlots = new ArrayList<MachineSlotWidget>();
    protected Button clearTextButton;
    protected Button clearRecipeButton;
    protected Button sortTypeButton;
    protected Button sortDirectionButton;
    protected Button jeiSyncButton;
    protected Button autocraftingModeButton;
    protected Button inventoryModeButton;
    protected LabelWidget storageSpaceLabel;
    protected int rows;
    protected int columns;
    protected int currentPage;
    protected int totalPages;
    protected boolean forceFocus;
    protected long lastClick;

    public StorageControllerGuiBase(T container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.storageControllerContainer = container;
        this.storageControllerContainer.getOrderSlot().func_110134_a((IInventoryChangedListener)this);
        this.field_146999_f = 224;
        this.field_147000_g = 256;
        this.rows = 4;
        this.columns = 9;
        this.currentPage = 1;
        this.totalPages = 1;
        this.stacks = new ArrayList<ItemStack>();
        this.linkedMachines = new ArrayList<MachineReference>();
        this.lastClick = System.currentTimeMillis();
        OccultismPackets.sendToServer(new MessageRequestStacks());
    }

    protected abstract boolean isGuiValid();

    protected abstract BlockPos getEntityPosition();

    public abstract SortDirection getSortDirection();

    public abstract void setSortDirection(SortDirection var1);

    public abstract SortType getSortType();

    public abstract void setSortType(SortType var1);

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    @Override
    public void drawGradientRect(MatrixStack matrixStack, int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_238468_a_(matrixStack, left, top, right, bottom, startColor, endColor);
    }

    @Override
    public boolean isPointInRegionController(int rectX, int rectY, int rectWidth, int rectHeight, double pointX, double pointY) {
        return this.func_195359_a(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    @Override
    public void renderToolTip(MatrixStack matrixStack, ItemStack stack, int x, int y) {
        super.func_230457_a_(matrixStack, stack, x, y);
    }

    @Override
    public void renderToolTip(MatrixStack matrixStack, MachineReference machine, int x, int y) {
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(machine.getItemStack().func_200301_q());
        if (machine.customName != null) {
            tooltip.add(new StringTextComponent(TextFormatting.GRAY.toString() + TextFormatting.BOLD + machine.customName + TextFormatting.RESET));
        }
        if (this.field_230706_i_.field_71439_g.field_70170_p.func_234923_W_() != machine.globalPos.getDimensionKey()) {
            tooltip.add(new TranslationTextComponent(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + machine.globalPos.getDimensionKey().func_240901_a_() + TextFormatting.RESET));
        }
        this.func_243308_b(matrixStack, tooltip, x, y);
    }

    @Override
    public void setStacks(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    @Override
    public void setUsedSlots(int slots) {
        this.usedSlots = slots;
    }

    @Override
    public void markDirty() {
        this.func_231160_c_();
    }

    @Override
    public void setMaxSlots(int slots) {
        this.maxSlots = slots;
    }

    @Override
    public void setLinkedMachines(List<MachineReference> machines) {
        this.linkedMachines = machines;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2 - 48;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.field_230710_m_.clear();
        int searchBarLeft = 57;
        int searchBarTop = 7;
        boolean focus = true;
        String searchBarText = "";
        if (this.searchBar != null) {
            searchBarText = this.searchBar.func_146179_b();
            if (!this.searchBar.func_230999_j_()) {
                focus = false;
            }
        }
        this.field_230712_o_.getClass();
        this.searchBar = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + searchBarLeft, this.field_147009_r + searchBarTop, 90, 9, (ITextComponent)new StringTextComponent("search"));
        this.searchBar.func_146203_f(30);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146193_g(Color.WHITE.getRGB());
        this.searchBar.func_146195_b(focus);
        this.searchBar.func_146180_a(searchBarText);
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            this.searchBar.func_146180_a(JeiAccess.getFilterText());
        }
        int storageSpaceInfoLabelLeft = 186;
        int storageSpaceInfoLabelTop = 115;
        this.storageSpaceLabel = new LabelWidget(this.field_147003_i + storageSpaceInfoLabelLeft, this.field_147009_r + storageSpaceInfoLabelTop, true, -1, 2, 0x404040);
        this.storageSpaceLabel.addLine(I18n.func_135052_a((String)"gui.occultism.storage_controller.space_info_label", (Object[])new Object[]{this.usedSlots, this.maxSlots}), false);
        this.func_230480_a_(this.storageSpaceLabel);
        this.initButtons();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        if (!this.isGuiValid()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return;
        }
        try {
            this.drawTooltips(matrixStack, mouseX, mouseY);
        }
        catch (Throwable e) {
            Occultism.LOGGER.error("Error drawing tooltip.", e);
        }
    }

    public void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.isGuiValid()) {
            return;
        }
        if (this.forceFocus) {
            this.searchBar.func_146195_b(true);
            if (this.searchBar.func_230999_j_()) {
                this.forceFocus = false;
            }
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        if (!this.isGuiValid()) {
            return;
        }
        this.func_230446_a_(matrixStack);
        this.drawBackgroundTexture(matrixStack);
        switch (this.guiMode) {
            case INVENTORY: {
                this.drawItems(matrixStack, partialTicks, mouseX, mouseY);
                break;
            }
            case AUTOCRAFTING: {
                this.drawMachines(matrixStack, partialTicks, mouseX, mouseY);
            }
        }
        this.searchBar.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        block4: {
            block5: {
                ItemStack stackCarriedByMouse;
                block6: {
                    block3: {
                        super.func_231044_a_(mouseX, mouseY, mouseButton);
                        this.searchBar.func_146195_b(false);
                        if (!this.isPointInSearchbar(mouseX, mouseY)) break block3;
                        this.searchBar.func_146195_b(true);
                        if (mouseButton != 1) break block4;
                        this.clearSearch();
                        break block4;
                    }
                    if (this.guiMode != StorageControllerGuiMode.INVENTORY) break block5;
                    stackCarriedByMouse = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
                    if (this.stackUnderMouse.func_190926_b() || mouseButton != 0 && mouseButton != 1 || !stackCarriedByMouse.func_190926_b() || !this.canClick()) break block6;
                    OccultismPackets.sendToServer(new MessageTakeItem(this.stackUnderMouse, mouseButton, Screen.func_231173_s_(), Screen.func_231172_r_()));
                    this.lastClick = System.currentTimeMillis();
                    break block4;
                }
                if (stackCarriedByMouse.func_190926_b() || !this.isPointInItemArea(mouseX, mouseY) || !this.canClick()) break block4;
                OccultismPackets.sendToServer(new MessageInsertMouseHeldItem(mouseButton));
                this.lastClick = System.currentTimeMillis();
                break block4;
            }
            if (this.guiMode == StorageControllerGuiMode.AUTOCRAFTING) {
                for (MachineSlotWidget slot : this.machineSlots) {
                    if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
                    if (mouseButton != 0) break;
                    ItemStack orderStack = this.storageControllerContainer.getOrderSlot().func_70301_a(0);
                    if (Screen.func_231173_s_()) {
                        long time = System.currentTimeMillis() + 5000L;
                        Occultism.SELECTED_BLOCK_RENDERER.selectBlock(slot.getMachine().globalPos.getPos(), time);
                        break;
                    }
                    if (orderStack.func_190926_b()) break;
                    OccultismPackets.sendToServer(new MessageRequestOrder(this.storageControllerContainer.getStorageControllerGlobalBlockPos(), slot.getMachine().globalPos, orderStack));
                    this.guiMode = StorageControllerGuiMode.INVENTORY;
                    break;
                }
            }
        }
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputMappings.Input mouseKey;
        if (this.searchBar.func_230999_j_() && this.searchBar.func_231046_a_(keyCode, scanCode, p_keyPressed_3_)) {
            if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
                JeiAccess.setFilterText(this.searchBar.func_146179_b());
            }
            return true;
        }
        if (this.searchBar.func_230999_j_() && this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_76316_a(IInventory inventory) {
        if (inventory == this.storageControllerContainer.getOrderSlot() && !inventory.func_70301_a(0).func_190926_b()) {
            this.guiMode = StorageControllerGuiMode.AUTOCRAFTING;
            this.func_231160_c_();
        }
    }

    public boolean func_231043_a_(double x, double y, double mouseButton) {
        super.func_231043_a_(x, y, mouseButton);
        if (this.isPointInItemArea(x, y)) {
            if (mouseButton > 0.0 && this.currentPage > 1) {
                --this.currentPage;
            }
            if (mouseButton < 0.0 && this.currentPage < this.totalPages) {
                ++this.currentPage;
            }
        }
        return true;
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.searchBar.func_230999_j_() && this.searchBar.func_231042_a_(typedChar, keyCode)) {
            OccultismPackets.sendToServer(new MessageRequestStacks());
            if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
                JeiAccess.setFilterText(this.searchBar.func_146179_b());
            }
        }
        return false;
    }

    public void initButtons() {
        int controlButtonSize = 12;
        int clearRecipeButtonLeft = 141;
        int clearRecipeButtonTop = 112;
        this.clearRecipeButton = new SizedImageButton(this.field_147003_i + clearRecipeButtonLeft, this.field_147009_r + clearRecipeButtonTop, controlButtonSize, controlButtonSize, 0, 196, 28, 28, 28, 256, 256, BUTTONS, button -> {
            OccultismPackets.sendToServer(new MessageClearCraftingMatrix());
            OccultismPackets.sendToServer(new MessageRequestStacks());
            this.func_231160_c_();
        });
        this.func_230480_a_((Widget)this.clearRecipeButton);
        int controlButtonTop = 5;
        int clearTextButtonLeft = 147;
        this.clearTextButton = new SizedImageButton(this.field_147003_i + clearTextButtonLeft, this.field_147009_r + controlButtonTop, controlButtonSize, controlButtonSize, 0, 196, 28, 28, 28, 256, 256, BUTTONS, button -> {
            this.clearSearch();
            this.forceFocus = true;
            this.func_231160_c_();
        });
        this.func_230480_a_((Widget)this.clearTextButton);
        int sortTypeOffset = this.getSortType().getValue() * 28;
        this.sortTypeButton = new SizedImageButton(this.field_147003_i + clearTextButtonLeft + controlButtonSize + 3, this.field_147009_r + controlButtonTop, controlButtonSize, controlButtonSize, 0, sortTypeOffset, 28, 28, 28, 256, 256, BUTTONS, button -> {
            this.setSortType(this.getSortType().next());
            OccultismPackets.sendToServer(new MessageSortItems(this.getEntityPosition(), this.getSortDirection(), this.getSortType()));
            this.func_231160_c_();
        });
        this.func_230480_a_((Widget)this.sortTypeButton);
        int sortDirectionOffset = 84 + (1 - this.getSortDirection().getValue()) * 28;
        this.sortDirectionButton = new SizedImageButton(this.field_147003_i + clearTextButtonLeft + controlButtonSize + 3 + controlButtonSize + 3, this.field_147009_r + controlButtonTop, controlButtonSize, controlButtonSize, 0, sortDirectionOffset, 28, 28, 28, 256, 256, BUTTONS, button -> {
            this.setSortDirection(this.getSortDirection().next());
            OccultismPackets.sendToServer(new MessageSortItems(this.getEntityPosition(), this.getSortDirection(), this.getSortType()));
            this.func_231160_c_();
        });
        this.func_230480_a_((Widget)this.sortDirectionButton);
        int jeiSyncOffset = 140 + (JeiSettings.isJeiSearchSynced() ? 0 : 1) * 28;
        this.jeiSyncButton = new SizedImageButton(this.field_147003_i + clearTextButtonLeft + controlButtonSize + 3 + controlButtonSize + 3 + controlButtonSize + 3, this.field_147009_r + controlButtonTop, controlButtonSize, controlButtonSize, 0, jeiSyncOffset, 28, 28, 28, 256, 256, BUTTONS, button -> {
            JeiSettings.setJeiSearchSync(!JeiSettings.isJeiSearchSynced());
            this.func_231160_c_();
        });
        if (JeiSettings.isJeiLoaded()) {
            this.func_230480_a_((Widget)this.jeiSyncButton);
        }
        int guiModeButtonTop = 112;
        int guiModeButtonLeft = 27;
        int guiModeButtonHeight = 29;
        int guiModeButtonWidth = 24;
        switch (this.guiMode) {
            case INVENTORY: {
                this.inventoryModeButton = new SizedImageButton(this.field_147003_i + guiModeButtonLeft, this.field_147009_r + 112, guiModeButtonWidth, guiModeButtonHeight, 160, 0, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.INVENTORY;
                    this.func_231160_c_();
                });
                this.autocraftingModeButton = new SizedImageButton(this.field_147003_i + guiModeButtonLeft, this.field_147009_r + guiModeButtonTop + guiModeButtonHeight, guiModeButtonWidth, guiModeButtonHeight, 160, 174, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.AUTOCRAFTING;
                    this.func_231160_c_();
                });
                break;
            }
            case AUTOCRAFTING: {
                this.inventoryModeButton = new SizedImageButton(this.field_147003_i + guiModeButtonLeft, this.field_147009_r + 112, guiModeButtonWidth, guiModeButtonHeight, 160, 58, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.INVENTORY;
                    this.func_231160_c_();
                });
                this.autocraftingModeButton = new SizedImageButton(this.field_147003_i + guiModeButtonLeft, this.field_147009_r + guiModeButtonTop + guiModeButtonHeight, guiModeButtonWidth, guiModeButtonHeight, 160, 116, 0, guiModeButtonWidth * 2, guiModeButtonHeight * 2, 256, 256, BUTTONS, button -> {
                    this.guiMode = StorageControllerGuiMode.AUTOCRAFTING;
                    this.func_231160_c_();
                });
            }
        }
        this.func_230480_a_((Widget)this.inventoryModeButton);
        this.func_230480_a_((Widget)this.autocraftingModeButton);
    }

    protected void drawItems(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        List<ItemStack> stacksToDisplay = this.applySearchToItems();
        this.sortItemStacks(stacksToDisplay);
        this.buildPage(stacksToDisplay);
        this.buildItemSlots(stacksToDisplay);
        this.drawItemSlots(matrixStack, mouseX, mouseY);
    }

    protected void drawMachines(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        List<MachineReference> machinesToDisplay = this.applySearchToMachines();
        this.sortMachines(machinesToDisplay);
        this.buildPage(machinesToDisplay);
        this.buildMachineSlots(machinesToDisplay);
        this.drawMachineSlots(matrixStack, mouseX, mouseY);
    }

    protected boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    protected boolean isPointInSearchbar(double mouseX, double mouseY) {
        int n = this.searchBar.field_230690_l_ - this.field_147003_i;
        int n2 = this.searchBar.field_230691_m_ - this.field_147009_r;
        int n3 = this.searchBar.func_230998_h_() - 5;
        this.field_230712_o_.getClass();
        return this.func_195359_a(n, n2, n3, 9 + 6, mouseX, mouseY);
    }

    protected boolean isPointInItemArea(double mouseX, double mouseY) {
        int itemAreaHeight = 82;
        int itemAreaWidth = 160;
        int itemAreaTop = 24;
        int itemAreaLeft = 56;
        return mouseX > (double)(this.field_147003_i + itemAreaLeft) && mouseX < (double)(this.field_147003_i + itemAreaWidth + itemAreaLeft) && mouseY > (double)(this.field_147009_r + itemAreaTop) && mouseY < (double)(this.field_147009_r + itemAreaTop + itemAreaHeight);
    }

    protected void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        switch (this.guiMode) {
            case INVENTORY: {
                for (ItemSlotWidget s : this.itemSlots) {
                    if (s == null || !s.isMouseOverSlot(mouseX, mouseY)) continue;
                    s.drawTooltip(matrixStack, mouseX, mouseY);
                }
                break;
            }
            case AUTOCRAFTING: {
                for (MachineSlotWidget s : this.machineSlots) {
                    if (s == null || !s.isMouseOverSlot(mouseX, mouseY)) continue;
                    s.drawTooltip(matrixStack, mouseX, mouseY);
                }
                break;
            }
        }
        if (this.isPointInSearchbar(mouseX, mouseY)) {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            if (!Screen.func_231173_s_()) {
                tooltip.add(new TranslationTextComponent("gui.occultism.storage_controller.shift"));
            } else {
                switch (this.guiMode) {
                    case INVENTORY: {
                        tooltip.add(new TranslationTextComponent("gui.occultism.storage_controller.search.tooltip@"));
                        tooltip.add(new TranslationTextComponent("gui.occultism.storage_controller.search.tooltip#"));
                        tooltip.add(new TranslationTextComponent("gui.occultism.storage_controller.search.tooltip$"));
                        break;
                    }
                    case AUTOCRAFTING: {
                        tooltip.add(new TranslationTextComponent("gui.occultism.storage_controller.search.machines.tooltip@"));
                    }
                }
                tooltip.add(new TranslationTextComponent("gui.occultism.storage_controller.search.tooltip_rightclick"));
            }
            this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
        }
        if (this.clearTextButton != null && this.clearTextButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.func_243308_b(matrixStack, Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent("gui.occultism.storage_controller.search.tooltip_clear")}), mouseX, mouseY);
        }
        if (this.sortTypeButton != null && this.sortTypeButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            String translationKey = "";
            switch (this.guiMode) {
                case INVENTORY: {
                    translationKey = "gui.occultism.storage_controller.search.tooltip_sort_type_" + this.getSortType().func_176610_l();
                    break;
                }
                case AUTOCRAFTING: {
                    translationKey = "gui.occultism.storage_controller.search.machines.tooltip_sort_type_" + this.getSortType().func_176610_l();
                }
            }
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent(translationKey), mouseX, mouseY);
        }
        if (this.sortDirectionButton != null && this.sortDirectionButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.occultism.storage_controller.search.tooltip_sort_direction_" + this.getSortDirection().func_176610_l()), mouseX, mouseY);
        }
        if (this.jeiSyncButton != null && this.jeiSyncButton.func_231047_b_((double)mouseX, (double)mouseY)) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.occultism.storage_controller.search.tooltip_jei_" + (JeiSettings.isJeiSearchSynced() ? "on" : "off")), mouseX, mouseY);
        }
    }

    protected void drawBackgroundTexture(MatrixStack matrixStack) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        int xCenter = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yCenter = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawItemSlots(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.stackUnderMouse = ItemStack.field_190927_a;
        for (ItemSlotWidget slot : this.itemSlots) {
            slot.drawSlot(matrixStack, mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
        }
    }

    protected void buildItemSlots(List<ItemStack> stacksToDisplay) {
        int itemAreaLeft = 56;
        int itemAreaTop = 24;
        this.itemSlots = new ArrayList<ItemSlotWidget>();
        int index = (this.currentPage - 1) * this.columns;
        for (int row = 0; row < this.rows && index < stacksToDisplay.size(); ++row) {
            for (int col = 0; col < this.columns && index < stacksToDisplay.size(); ++index, ++col) {
                this.itemSlots.add(new ItemSlotWidget(this, stacksToDisplay.get(index), this.field_147003_i + itemAreaLeft + col * 18, this.field_147009_r + itemAreaTop + row * 18, stacksToDisplay.get(index).func_190916_E(), this.field_147003_i, this.field_147009_r, true));
            }
        }
    }

    protected void buildPage(List<?> objectsToDisplay) {
        this.totalPages = objectsToDisplay.size() / this.columns;
        if (objectsToDisplay.size() % this.columns != 0) {
            ++this.totalPages;
        }
        this.totalPages -= this.rows - 1;
        if (this.totalPages < 1) {
            this.totalPages = 1;
        }
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
        if (this.currentPage > this.totalPages) {
            this.currentPage = this.totalPages;
        }
    }

    protected void sortItemStacks(List<ItemStack> stacksToDisplay) {
        stacksToDisplay.sort(new Comparator<ItemStack>(){
            int direction;
            {
                this.direction = StorageControllerGuiBase.this.getSortDirection().isDown() ? -1 : 1;
            }

            @Override
            public int compare(ItemStack a, ItemStack b) {
                switch (StorageControllerGuiBase.this.getSortType()) {
                    case AMOUNT: {
                        return Integer.compare(b.func_190916_E(), a.func_190916_E()) * this.direction;
                    }
                    case NAME: {
                        return a.func_200301_q().func_150261_e().compareToIgnoreCase(b.func_200301_q().func_150261_e()) * this.direction;
                    }
                    case MOD: {
                        return TextUtil.getModNameForGameObject(a.func_77973_b()).compareToIgnoreCase(TextUtil.getModNameForGameObject(b.func_77973_b())) * this.direction;
                    }
                }
                return 0;
            }
        });
    }

    protected List<ItemStack> applySearchToItems() {
        String searchText = this.searchBar.func_146179_b();
        if (!searchText.equals("")) {
            ArrayList<ItemStack> stacksToDisplay = new ArrayList<ItemStack>();
            for (ItemStack stack : this.stacks) {
                if (!this.itemMatchesSearch(stack)) continue;
                stacksToDisplay.add(stack);
            }
            return stacksToDisplay;
        }
        return new ArrayList<ItemStack>(this.stacks);
    }

    protected List<MachineReference> applySearchToMachines() {
        String searchText = this.searchBar.func_146179_b();
        if (!searchText.equals("")) {
            ArrayList<MachineReference> machinesToDisplay = new ArrayList<MachineReference>();
            for (MachineReference machine : this.linkedMachines) {
                if (!this.machineMatchesSearch(machine)) continue;
                machinesToDisplay.add(machine);
            }
            return machinesToDisplay;
        }
        return new ArrayList<MachineReference>(this.linkedMachines);
    }

    protected boolean itemMatchesSearch(ItemStack stack) {
        String searchText = this.searchBar.func_146179_b();
        if (searchText.startsWith("@")) {
            String name = TextUtil.getModNameForGameObject(stack.func_77973_b());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("#")) {
            List tooltip = stack.func_82840_a((PlayerEntity)this.field_230706_i_.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().map(ITextComponent::func_150261_e).collect(Collectors.toList());
            String tooltipString = Joiner.on((char)' ').join(tooltip).toLowerCase();
            return tooltipString.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("$")) {
            StringBuilder tagStringBuilder = new StringBuilder();
            for (ResourceLocation tag : stack.func_77973_b().getTags()) {
                tagStringBuilder.append(tag.toString()).append(' ');
            }
            return tagStringBuilder.toString().toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        return stack.func_200301_q().getString().toLowerCase().contains(searchText.toLowerCase());
    }

    protected boolean machineMatchesSearch(MachineReference machine) {
        String searchText = this.searchBar.func_146179_b();
        if (searchText.startsWith("@")) {
            String name = TextUtil.getModNameForGameObject(machine.getItem());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        String customName = machine.customName == null ? "" : machine.customName.toLowerCase();
        return machine.getItemStack().func_200301_q().func_150261_e().toLowerCase().contains(searchText.toLowerCase()) || customName.contains(searchText.toLowerCase().substring(1));
    }

    protected void sortMachines(List<MachineReference> machinesToDisplay) {
        final BlockPos entityPosition = this.getEntityPosition();
        final RegistryKey dimensionKey = this.field_230706_i_.field_71439_g.field_70170_p.func_234923_W_();
        machinesToDisplay.sort(new Comparator<MachineReference>(){
            int direction;
            {
                this.direction = StorageControllerGuiBase.this.getSortDirection().isDown() ? -1 : 1;
            }

            @Override
            public int compare(MachineReference a, MachineReference b) {
                switch (StorageControllerGuiBase.this.getSortType()) {
                    case AMOUNT: {
                        double distanceA = a.globalPos.getDimensionKey() == dimensionKey ? a.globalPos.getPos().func_177951_i((Vector3i)entityPosition) : Double.MAX_VALUE;
                        double distanceB = b.globalPos.getDimensionKey() == dimensionKey ? b.globalPos.getPos().func_177951_i((Vector3i)entityPosition) : Double.MAX_VALUE;
                        return Double.compare(distanceB, distanceA) * this.direction;
                    }
                    case NAME: {
                        return a.getItemStack().func_200301_q().func_150261_e().compareToIgnoreCase(b.getItemStack().func_200301_q().func_150261_e()) * this.direction;
                    }
                    case MOD: {
                        return TextUtil.getModNameForGameObject(a.getItem()).compareToIgnoreCase(TextUtil.getModNameForGameObject(b.getItem())) * this.direction;
                    }
                }
                return 0;
            }
        });
    }

    protected void buildMachineSlots(List<MachineReference> machinesToDisplay) {
        int itemAreaLeft = 56;
        int itemAreaTop = 24;
        this.machineSlots = new ArrayList<MachineSlotWidget>();
        int index = (this.currentPage - 1) * this.columns;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.columns && index < machinesToDisplay.size(); ++index, ++col) {
                this.machineSlots.add(new MachineSlotWidget(this, machinesToDisplay.get(index), this.field_147003_i + itemAreaLeft + col * 18, this.field_147009_r + itemAreaTop + row * 18, this.field_147003_i, this.field_147009_r));
            }
        }
    }

    protected void drawMachineSlots(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (MachineSlotWidget slot : this.machineSlots) {
            slot.drawSlot(matrixStack, mouseX, mouseY);
        }
    }

    protected void clearSearch() {
        this.searchBar.func_146180_a("");
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            JeiAccess.setFilterText("");
        }
    }
}

