/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render;

import com.github.klikli_dev.occultism.client.render.OccultismRenderType;
import com.github.klikli_dev.occultism.util.RenderUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SelectedBlockRenderer {
    protected Set<SelectionInfo> selectedBlocks = new HashSet<SelectionInfo>();

    public void selectBlock(BlockPos pos, long expireTime) {
        this.selectBlock(pos, expireTime, new Color(1.0f, 1.0f, 1.0f, 0.8f));
    }

    public void selectBlock(BlockPos pos, long expireTime, Color color) {
        SelectionInfo info = new SelectionInfo(pos, expireTime, color);
        if (this.selectedBlocks.contains(info)) {
            this.selectedBlocks.remove(info);
        }
        this.selectedBlocks.add(info);
    }

    public void unselectBlock(BlockPos pos) {
        this.selectedBlocks.removeIf(info -> info.selectedBlock.equals((Object)pos));
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        this.renderSelectedBlocks(event);
    }

    protected void renderSelectedBlocks(RenderWorldLastEvent event) {
        if (!this.selectedBlocks.isEmpty()) {
            long time = System.currentTimeMillis();
            MatrixStack matrixStack = event.getMatrixStack();
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            IVertexBuilder builder = buffer.getBuffer(OccultismRenderType.BLOCK_SELECTION);
            matrixStack.func_227860_a_();
            Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
            matrixStack.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
            Matrix4f transform = matrixStack.func_227866_c_().func_227870_a_();
            Iterator<SelectionInfo> it = this.selectedBlocks.iterator();
            while (it.hasNext()) {
                SelectionInfo info = it.next();
                if (time > info.selectionExpireTime || info.selectedBlock == null) {
                    it.remove();
                    return;
                }
                RenderUtil.buildBlockOutline(builder, transform, info.selectedBlock.func_177958_n(), info.selectedBlock.func_177956_o(), info.selectedBlock.func_177952_p(), (float)info.color.getRed() / 255.0f, (float)info.color.getGreen() / 255.0f, (float)info.color.getBlue() / 255.0f, (float)info.color.getAlpha() / 255.0f);
            }
            matrixStack.func_227865_b_();
            RenderSystem.enableTexture();
            RenderSystem.disableDepthTest();
            buffer.func_228462_a_(OccultismRenderType.BLOCK_SELECTION);
            RenderSystem.enableDepthTest();
        }
    }

    public class SelectionInfo {
        public BlockPos selectedBlock;
        public long selectionExpireTime;
        public Color color;

        public SelectionInfo(BlockPos selectedBlock, long selectionExpireTime, Color color) {
            this.selectedBlock = selectedBlock;
            this.selectionExpireTime = selectionExpireTime;
            this.color = color;
        }

        public int hashCode() {
            return this.selectedBlock.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            SelectionInfo other = (SelectionInfo)obj;
            if (other == null) {
                return false;
            }
            return other.selectedBlock.equals((Object)this.selectedBlock);
        }
    }
}

