/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.api.common.data.OtherworldBlockTier;
import com.github.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.github.klikli_dev.occultism.util.CuriosUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ThirdEyeEffectRenderer {
    public static final int MAX_THIRD_EYE_DISTANCE = 10;
    public static final ResourceLocation THIRD_EYE_SHADER = new ResourceLocation("occultism", "shaders/post/third_eye.json");
    public static final ResourceLocation THIRD_EYE_OVERLAY = new ResourceLocation("occultism", "textures/overlay/third_eye.png");
    public boolean thirdEyeActiveLastTick = false;
    public boolean gogglesActiveLastTick = false;
    public Set<BlockPos> uncoveredBlocks = new HashSet<BlockPos>();

    private static void renderOverlay(RenderGameOverlayEvent.Post event, ResourceLocation texture) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        RenderSystem.pushMatrix();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(0.0, (double)window.func_198087_p(), -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)window.func_198107_o(), (double)window.func_198087_p(), -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)window.func_198107_o(), 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K && event.player == Minecraft.func_71410_x().field_71439_g) {
            this.onThirdEyeTick(event);
            this.onGogglesTick(event);
        }
    }

    @SubscribeEvent
    public void onPreRenderOverlay(RenderGameOverlayEvent.Pre event) {
        RenderSystem.enableTexture();
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET && (this.thirdEyeActiveLastTick || this.gogglesActiveLastTick)) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ThirdEyeEffectRenderer.renderOverlay(event, THIRD_EYE_OVERLAY);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    }

    public void resetUncoveredBlocks(World world, boolean clear) {
        for (BlockPos pos : this.uncoveredBlocks) {
            BlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof IOtherworldBlock)) continue;
            world.func_180501_a(pos, (BlockState)state.func_206870_a(IOtherworldBlock.UNCOVERED, (Comparable)Boolean.valueOf(false)), 1);
        }
        if (clear) {
            this.uncoveredBlocks.clear();
        }
    }

    public void uncoverBlocks(PlayerEntity player, World world, OtherworldBlockTier level) {
        BlockPos origin = player.func_233580_cy_();
        BlockPos.func_218278_a((BlockPos)origin.func_177982_a(-10, -10, -10), (BlockPos)origin.func_177982_a(10, 10, 10)).forEach(pos -> {
            IOtherworldBlock block;
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof IOtherworldBlock && (block = (IOtherworldBlock)state.func_177230_c()).getTier().getLevel() <= level.getLevel()) {
                if (!((Boolean)state.func_177229_b(IOtherworldBlock.UNCOVERED)).booleanValue()) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a(IOtherworldBlock.UNCOVERED, (Comparable)Boolean.valueOf(true)), 1);
                }
                this.uncoveredBlocks.add(pos.func_185334_h());
            }
        });
    }

    public void onThirdEyeTick(TickEvent.PlayerTickEvent event) {
        int duration;
        boolean hasGoggles = CuriosUtil.hasGoggles(event.player);
        EffectInstance effect = event.player.func_70660_b((Effect)OccultismEffects.THIRD_EYE.get());
        int n = duration = effect == null ? 0 : effect.func_76459_b();
        if (duration > 1) {
            if (!this.thirdEyeActiveLastTick) {
                this.thirdEyeActiveLastTick = true;
                if (!hasGoggles && !Occultism.CLIENT_CONFIG.visuals.disableDemonsDreamShaders.get()) {
                    Minecraft.func_71410_x().func_212871_a_(() -> Minecraft.func_71410_x().field_71460_t.func_175069_a(THIRD_EYE_SHADER));
                }
            }
            this.uncoverBlocks(event.player, event.player.field_70170_p, hasGoggles ? OtherworldBlockTier.TWO : OtherworldBlockTier.ONE);
        } else {
            if (!hasGoggles) {
                this.resetUncoveredBlocks(event.player.field_70170_p, duration == 0);
            }
            if (this.thirdEyeActiveLastTick) {
                this.thirdEyeActiveLastTick = false;
                Minecraft.func_71410_x().func_212871_a_(() -> Minecraft.func_71410_x().field_71460_t.func_181022_b());
            }
        }
    }

    public void onGogglesTick(TickEvent.PlayerTickEvent event) {
        boolean hasGoggles = CuriosUtil.hasGoggles(event.player);
        if (hasGoggles) {
            if (!this.gogglesActiveLastTick) {
                this.gogglesActiveLastTick = true;
            }
            if (!this.thirdEyeActiveLastTick) {
                this.uncoverBlocks(event.player, event.player.field_70170_p, OtherworldBlockTier.TWO);
            }
        } else {
            if (this.gogglesActiveLastTick) {
                this.gogglesActiveLastTick = false;
            }
            this.resetUncoveredBlocks(event.player.field_70170_p, true);
            if (this.thirdEyeActiveLastTick) {
                this.uncoverBlocks(event.player, event.player.field_70170_p, OtherworldBlockTier.ONE);
            }
        }
    }
}

