/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block;

import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventory;
import com.github.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpiritFireBlock
extends Block {
    public SpiritFireBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FireBlock.field_176543_a, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? (BlockState)this.func_176223_P().func_206870_a((Property)FireBlock.field_176543_a, stateIn.func_177229_b((Property)FireBlock.field_176543_a)) : Blocks.field_150350_a.func_176223_P();
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            } else {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, SpiritFireBlock.getTickCooldown(worldIn.field_73012_v));
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable((IBlockReader)worldIn, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, SpiritFireBlock.getTickCooldown(worldIn.field_73012_v));
        if (!worldIn.isAreaLoaded(pos, 2)) {
            return;
        }
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_217377_a(pos, false);
        }
        if (!worldIn.field_72995_K) {
            this.convertItems((World)worldIn, pos, state);
        }
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        BlockState other = worldIn.func_180495_p(pos.func_177977_b());
        boolean isOnFireSource = other.isFireSource((IWorldReader)worldIn, pos.func_177977_b(), Direction.UP);
        int i = (Integer)state.func_177229_b((Property)FireBlock.field_176543_a);
        if (!isOnFireSource && worldIn.func_72896_J() && this.canDie((World)worldIn, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
            worldIn.func_217377_a(pos, false);
        } else {
            int j = Math.min(15, i + rand.nextInt(3) / 2);
            if (i != j) {
                state = (BlockState)state.func_206870_a((Property)FireBlock.field_176543_a, (Comparable)Integer.valueOf(j));
                worldIn.func_180501_a(pos, state, 4);
            }
            if (!isOnFireSource) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, SpiritFireBlock.getTickCooldown(worldIn.field_73012_v));
                if (!this.areNeighborsFlammable((IBlockReader)worldIn, pos)) {
                    BlockPos blockpos = pos.func_177977_b();
                    if (!worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || i > 3) {
                        worldIn.func_217377_a(pos, false);
                    }
                    return;
                }
                if (i == 15 && rand.nextInt(4) == 0 && !this.canCatchFire((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP)) {
                    worldIn.func_217377_a(pos, false);
                    return;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        block12: {
            block11: {
                if (rand.nextInt(24) == 0) {
                    worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                BlockPos blockpos = pos.func_177977_b();
                BlockState blockstate = worldIn.func_180495_p(blockpos);
                if (this.canCatchFire((IBlockReader)worldIn, blockpos, Direction.UP) || Block.func_220064_c((IBlockReader)worldIn, (BlockPos)blockpos)) break block11;
                if (this.canCatchFire((IBlockReader)worldIn, blockpos.func_177976_e(), Direction.EAST)) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)pos.func_177958_n() + rand.nextDouble() * (double)0.1f;
                        double d8 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d13 = (double)pos.func_177952_p() + rand.nextDouble();
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d3, d8, d13, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((IBlockReader)worldIn, pos.func_177974_f(), Direction.WEST)) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(pos.func_177958_n() + 1) - rand.nextDouble() * (double)0.1f;
                        double d9 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d14 = (double)pos.func_177952_p() + rand.nextDouble();
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d4, d9, d14, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((IBlockReader)worldIn, pos.func_177978_c(), Direction.SOUTH)) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d10 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d15 = (double)pos.func_177952_p() + rand.nextDouble() * (double)0.1f;
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d5, d10, d15, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((IBlockReader)worldIn, pos.func_177968_d(), Direction.NORTH)) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d11 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d16 = (double)(pos.func_177952_p() + 1) - rand.nextDouble() * (double)0.1f;
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d6, d11, d16, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canCatchFire((IBlockReader)worldIn, pos.func_177984_a(), Direction.DOWN)) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)pos.func_177958_n() + rand.nextDouble();
                    double d12 = (double)(pos.func_177956_o() + 1) - rand.nextDouble() * (double)0.1f;
                    double d17 = (double)pos.func_177952_p() + rand.nextDouble();
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d7, d12, d17, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble();
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble();
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FireBlock.field_176543_a});
        super.func_206840_a(builder);
    }

    private static int getTickCooldown(Random rand) {
        return 30 + rand.nextInt(10);
    }

    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        return world.func_180495_p(pos).isFlammable(world, pos, face);
    }

    protected void convertItems(World world, BlockPos pos, BlockState state) {
        Vector3d center = Math3DUtil.center(pos);
        AxisAlignedBB box = new AxisAlignedBB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5).func_191194_a(center);
        List list = world.func_217357_a(ItemEntity.class, box);
        ItemStackFakeInventory fakeInventory = new ItemStackFakeInventory(ItemStack.field_190927_a);
        boolean convertedAnyItem = false;
        for (ItemEntity item : list) {
            fakeInventory.func_70299_a(0, item.func_92059_d());
            Optional recipe = world.func_199532_z().func_215371_a((IRecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get(), (IInventory)fakeInventory, world);
            if (!recipe.isPresent()) continue;
            convertedAnyItem = true;
            item.func_70106_y();
            ItemStack result = ((SpiritFireRecipe)recipe.get()).getCraftingResult(fakeInventory);
            InventoryHelper.func_180173_a((World)world, (double)center.field_72450_a, (double)(center.field_72448_b + 0.5), (double)center.field_72449_c, (ItemStack)result);
        }
        if (convertedAnyItem) {
            world.func_184133_a(null, pos, (SoundEvent)OccultismSounds.START_RITUAL.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected boolean canDie(World worldIn, BlockPos pos) {
        return worldIn.func_175727_C(pos) || worldIn.func_175727_C(pos.func_177976_e()) || worldIn.func_175727_C(pos.func_177974_f()) || worldIn.func_175727_C(pos.func_177978_c()) || worldIn.func_175727_C(pos.func_177968_d());
    }

    private int getNeighborEncouragement(IWorldReader worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            i = Math.max(blockstate.getFlammability((IBlockReader)worldIn, pos.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i;
    }

    private boolean areNeighborsFlammable(IBlockReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }
}

