/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.capability;

import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class FamiliarSettingsCapability {
    private boolean greedyEnabled = true;
    private boolean otherworldBirdEnabled = true;

    public void clone(FamiliarSettingsCapability settings) {
        this.greedyEnabled = settings.greedyEnabled;
        this.otherworldBirdEnabled = settings.otherworldBirdEnabled;
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74757_a("greedyEnabled", this.greedyEnabled);
        compound.func_74757_a("otherworldBirdEnabled", this.otherworldBirdEnabled);
        return compound;
    }

    public CompoundNBT read(CompoundNBT compound) {
        this.greedyEnabled = compound.func_74767_n("greedyEnabled");
        this.otherworldBirdEnabled = compound.func_74767_n("otherworldBirdEnabled");
        return compound;
    }

    public boolean isGreedyEnabled() {
        return this.greedyEnabled;
    }

    public void setGreedyEnabled(boolean greedyEnabled) {
        this.greedyEnabled = greedyEnabled;
    }

    public boolean isOtherworldBirdEnabled() {
        return this.otherworldBirdEnabled;
    }

    public void setOtherworldBirdEnabled(boolean otherworldBirdEnabled) {
        this.otherworldBirdEnabled = otherworldBirdEnabled;
    }

    public static class Dispatcher
    implements ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<FamiliarSettingsCapability> familiarSettingsCapability = LazyOptional.of(FamiliarSettingsCapability::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == OccultismCapabilities.FAMILIAR_SETTINGS) {
                return this.familiarSettingsCapability.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            this.familiarSettingsCapability.ifPresent(capability -> capability.write(nbt));
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.familiarSettingsCapability.ifPresent(capability -> capability.read(nbt));
        }
    }

    public static class Storage
    implements Capability.IStorage<FamiliarSettingsCapability> {
        public INBT writeNBT(Capability<FamiliarSettingsCapability> capability, FamiliarSettingsCapability instance, Direction facing) {
            return instance.write(new CompoundNBT());
        }

        public void readNBT(Capability<FamiliarSettingsCapability> capability, FamiliarSettingsCapability instance, Direction side, INBT nbt) {
            instance.read((CompoundNBT)nbt);
        }
    }
}

