/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container.spirit;

import com.github.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SpiritTransporterContainer
extends SpiritContainer {
    protected final PlayerEntity player;

    public SpiritTransporterContainer(int id, PlayerInventory playerInventory, SpiritEntity spirit) {
        super((ContainerType)OccultismContainers.SPIRIT_TRANSPORTER.get(), id, playerInventory, spirit);
        this.player = playerInventory.field_70458_d;
        this.setupFilterSlots();
    }

    @Override
    protected void setupPlayerInventorySlots(PlayerEntity player) {
        int playerInventoryTop = 120;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    @Override
    protected void setupPlayerHotbar(PlayerEntity player) {
        int hotbarTop = 178;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    public ItemStack func_184996_a(int id, int dragType, ClickType clickType, PlayerEntity player) {
        Slot slot = id >= 0 ? this.func_75139_a(id) : null;
        ItemStack holding = player.field_71071_by.func_70445_o();
        if (slot instanceof FilterSlot) {
            if (holding.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else if (slot.func_75214_a(holding)) {
                slot.func_75215_d(holding.func_77946_l());
            }
            return holding;
        }
        return super.func_184996_a(id, dragType, clickType, player);
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        if (slot instanceof FilterSlot) {
            return false;
        }
        return super.func_94530_a(stack, slot);
    }

    protected void setupFilterSlots() {
        int x = 8;
        int y = 84;
        ItemStackHandler filterItems = (ItemStackHandler)this.spirit.filterItemStackHandler.orElseThrow(ItemHandlerMissingException::new);
        for (int i = 0; i < filterItems.getSlots(); ++i) {
            this.func_75146_a((Slot)new FilterSlot((IItemHandler)filterItems, i, x, y));
            x += 18;
        }
    }

    public class FilterSlot
    extends SlotItemHandler {
        public FilterSlot(IItemHandler handler, int inventoryIndex, int x, int y) {
            super(handler, inventoryIndex, x, y);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            if (!stack.func_190926_b()) {
                stack.func_190920_e(1);
            }
            super.func_75215_d(stack);
        }
    }
}

