/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container.storage;

import com.github.klikli_dev.occultism.common.container.storage.SatchelInventory;
import com.github.klikli_dev.occultism.common.container.storage.SatchelSlot;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.util.CuriosUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class SatchelContainer
extends Container {
    public static final int SATCHEL_SIZE = 117;
    protected IInventory satchelInventory;
    protected PlayerInventory playerInventory;
    protected int selectedSlot;

    public SatchelContainer(int id, PlayerInventory playerInventory, IInventory satchelInventory, int selectedSlot) {
        super((ContainerType)OccultismContainers.SATCHEL.get(), id);
        this.satchelInventory = satchelInventory;
        this.playerInventory = playerInventory;
        this.selectedSlot = selectedSlot;
        this.setupSatchelSlots();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
    }

    public void func_75142_b() {
        if (this.satchelInventory instanceof SatchelInventory) {
            ((SatchelInventory)this.satchelInventory).writeItemStack();
        }
        super.func_75142_b();
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= this.satchelInventory.func_70302_i_() && itemstack.func_77973_b() == OccultismItems.SATCHEL.get()) {
                return ItemStack.field_190927_a;
            }
            if (index < this.satchelInventory.func_70302_i_() ? !this.func_75135_a(itemstack1, this.satchelInventory.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.satchelInventory.func_70302_i_(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (this.selectedSlot == -1) {
            return CuriosUtil.getBackpack(player).func_77973_b() == OccultismItems.SATCHEL.get();
        }
        if (this.selectedSlot < 0 || this.selectedSlot >= player.field_71071_by.func_70302_i_()) {
            return false;
        }
        return player.field_71071_by.func_70301_a(this.selectedSlot).func_77973_b() == OccultismItems.SATCHEL.get();
    }

    public static SatchelContainer createClientContainer(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        int selectedSlot = buffer.func_150792_a();
        return new SatchelContainer(id, playerInventory, (IInventory)new Inventory(117), selectedSlot);
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 174;
        int playerInventoryLeft = 44;
        int hotbarSlots = 9;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + hotbarSlots, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 44;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupSatchelSlots() {
        int height = 9;
        int width = 13;
        int x = 8;
        int y = 8;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                this.func_75146_a(new SatchelSlot(this.satchelInventory, j + i * width, x + j * 18, y + i * 18));
            }
        }
    }
}

