/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class GreedyFamiliarEntity
extends CreatureEntity
implements IFamiliar {
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(GreedyFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(GreedyFamiliarEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public LivingEntity ownerCached;

    public GreedyFamiliarEntity(EntityType<? extends GreedyFamiliarEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FindItemGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        this.setOwnerId(owner.func_110124_au());
    }

    public LivingEntity getOwnerCached() {
        if (this.ownerCached != null) {
            return this.ownerCached;
        }
        this.ownerCached = this.getOwner();
        return this.ownerCached;
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() == OccultismItems.FAMILIAR_RING.get()) {
            return stack.func_111282_a_(playerIn, (LivingEntity)this, hand);
        }
        if (stack.func_77973_b() == OccultismItems.DEBUG_WAND.get()) {
            this.setOwnerId(playerIn.func_110124_au());
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.field_70170_p.field_72995_K && this.getFamiliarOwner() == playerIn) {
            this.setSitting(!this.isSitting());
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    @Override
    public LivingEntity getFamiliarOwner() {
        return this.getOwnerCached();
    }

    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(UUID id) {
        this.ownerCached = null;
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(id));
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (!(wearer instanceof PlayerEntity)) {
            return;
        }
        wearer.getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).ifPresent(cap -> {
            if (cap.isGreedyEnabled()) {
                for (ItemEntity e : this.field_70170_p.func_217357_a(ItemEntity.class, wearer.func_174813_aQ().func_186662_g(5.0))) {
                    ItemStack stack = e.func_92059_d().getStack();
                    boolean isDemagnetized = stack.func_77942_o() && stack.func_77978_p().func_74767_n("PreventRemoteMovement");
                    if (isDemagnetized) continue;
                    e.func_70100_b_((PlayerEntity)wearer);
                }
            }
        });
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("owner")) {
            this.setOwnerId(compound.func_186857_a("owner"));
        }
        if (compound.func_74764_b("isSitting")) {
            this.setSitting(compound.func_74767_n("isSitting"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() != null) {
            compound.func_186854_a("owner", this.getOwnerId());
        }
        compound.func_74757_a("isSitting", this.isSitting());
    }

    private void setSitting(boolean b) {
        this.field_70180_af.func_187227_b(SITTING, (Object)b);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    private static class FindItemGoal
    extends Goal {
        private static final double RANGE = 12.0;
        private GreedyFamiliarEntity entity;

        public FindItemGoal(GreedyFamiliarEntity raptor) {
            this.entity = raptor;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.getNearbyItem() != null && this.entity.getFamiliarOwner() instanceof PlayerEntity;
        }

        public void func_75249_e() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.func_70661_as().func_75497_a((Entity)item, 1.2);
            }
        }

        public void func_75246_d() {
            ItemEntity item = this.getNearbyItem();
            if (item != null) {
                this.entity.func_70661_as().func_75497_a((Entity)item, 1.2);
                LivingEntity owner = this.entity.getFamiliarOwner();
                if (item.func_70068_e((Entity)this.entity) < 4.0 && owner instanceof PlayerEntity) {
                    item.func_70100_b_((PlayerEntity)owner);
                }
            }
        }

        private ItemEntity getNearbyItem() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (!(owner instanceof PlayerEntity)) {
                return null;
            }
            PlayerEntity player = (PlayerEntity)owner;
            PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.field_71071_by);
            for (ItemEntity item : this.entity.field_70170_p.func_217357_a(ItemEntity.class, this.entity.func_174813_aQ().func_186662_g(12.0))) {
                ItemStack stack = item.func_92059_d();
                boolean isDemagnetized = stack.func_77942_o() && stack.func_77978_p().func_74767_n("PreventRemoteMovement");
                if (isDemagnetized || ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)true).func_190916_E() == stack.func_190916_E()) continue;
                return item;
            }
            return null;
        }
    }

    private class SitGoal
    extends Goal {
        private final GreedyFamiliarEntity entity;

        public SitGoal(GreedyFamiliarEntity entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.entity.func_203005_aq() && this.entity.func_233570_aj_() && this.entity.getFamiliarOwner() != null && this.entity.isSitting();
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.entity.setSitting(false);
        }
    }

    public class FollowOwnerGoal
    extends Goal {
        private GreedyFamiliarEntity entity;
        private double speed;
        private int cooldown;
        private float maxDist;
        private float minDist;
        private LivingEntity owner;

        public FollowOwnerGoal(GreedyFamiliarEntity entity, double speed, float minDist, float maxDist) {
            this.entity = entity;
            this.speed = speed;
            this.minDist = minDist * minDist;
            this.maxDist = maxDist * maxDist;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean shouldFollow(double distance) {
            return this.owner != null && !this.owner.func_175149_v() && this.entity.func_70068_e((Entity)this.owner) > distance;
        }

        public boolean func_75250_a() {
            this.owner = this.entity.getFamiliarOwner();
            return this.shouldFollow(this.minDist);
        }

        public boolean func_75253_b() {
            return this.shouldFollow(this.maxDist);
        }

        public void func_75249_e() {
            this.cooldown = 0;
        }

        public void func_75251_c() {
            this.owner = null;
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.entity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.entity.func_70646_bf());
            if (--this.cooldown < 0) {
                this.cooldown = 10;
                if (!this.entity.func_110167_bD() && !this.entity.func_184218_aH()) {
                    this.entity.func_70661_as().func_75497_a((Entity)this.owner, this.speed);
                }
            }
        }
    }
}

