/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import com.github.klikli_dev.occultism.registry.OccultismEffects;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.FollowMobGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class OtherworldBirdEntity
extends ParrotEntity
implements IFamiliar {
    public static final float MAX_BOOST_DISTANCE = 8.0f;
    public LivingEntity ownerCached;
    public SitGoal sitGoal;

    public OtherworldBirdEntity(EntityType<? extends ParrotEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public LivingEntity getOwnerCached() {
        if (this.ownerCached != null) {
            return this.ownerCached;
        }
        this.ownerCached = this.func_70902_q();
        return this.ownerCached;
    }

    protected void func_184651_r() {
        this.sitGoal = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)this.sitGoal);
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 5.0f, 1.0f, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomFlyingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowMobGoal((MobEntity)this, 1.0, 3.0f, 7.0f));
    }

    public void func_70636_d() {
        LivingEntity owner;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 10L == 0L && this.func_70909_n() && (owner = this.getOwnerCached()) != null && this.func_70032_d((Entity)owner) < 8.0f) {
            for (EffectInstance effect : this.getFamiliarEffects()) {
                owner.func_195064_c(effect);
            }
        }
        super.func_70636_d();
    }

    public void func_184754_b(@Nullable UUID ownerId) {
        this.ownerCached = null;
        super.func_184754_b(ownerId);
    }

    @Override
    public LivingEntity getFamiliarOwner() {
        return this.getOwnerCached();
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        this.func_184754_b(owner.func_110124_au());
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    @Override
    public Iterable<EffectInstance> getFamiliarEffects() {
        if (this.getFamiliarOwner().getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).map(FamiliarSettingsCapability::isOtherworldBirdEnabled).orElse(false).booleanValue()) {
            return ImmutableList.of((Object)new EffectInstance(Effects.field_76430_j, 60, 5, false, false), (Object)new EffectInstance(Effects.field_204839_B, 20 * Occultism.SERVER_CONFIG.spiritJobs.drikwingFamiliarSlowFallingSeconds.get(), 0, false, false), (Object)new EffectInstance((Effect)OccultismEffects.DOUBLE_JUMP.get(), 120, 4, false, false));
        }
        return Collections.emptyList();
    }

    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() == OccultismItems.FAMILIAR_RING.get()) {
            return stack.func_111282_a_(playerIn, (LivingEntity)this, hand);
        }
        return super.func_230254_b_(playerIn, hand);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return ParrotEntity.func_234213_eS_();
    }
}

