/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.network.MessageSelectBlock;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class FellTreesGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos targetBlock = null;
    protected BlockPos moveTarget = null;
    protected int breakingTime;
    protected int previousBreakProgress;

    public FellTreesGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.targetBlock = null;
        this.moveTarget = null;
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_179680_a(this.moveTarget, 0), 1.0);
            if (Occultism.DEBUG.debugAI) {
                OccultismPackets.sendToTracking((Entity)this.entity, new MessageSelectBlock(this.targetBlock, 5000, 0xFFFFFF));
                OccultismPackets.sendToTracking((Entity)this.entity, new MessageSelectBlock(this.moveTarget, 5000, 65280));
            }
            if (FellTreesGoal.isLog(this.entity.field_70170_p, this.targetBlock)) {
                double distance = this.entity.func_213303_ch().func_72438_d(Math3DUtil.center(this.moveTarget));
                if (distance < 2.5) {
                    if (distance < 1.0) {
                        this.entity.func_213293_j(0.0, 0.0, 0.0);
                        this.entity.func_70661_as().func_75499_g();
                    }
                    this.updateBreakBlock();
                }
            } else {
                this.func_75251_c();
            }
        }
    }

    public static final boolean isLog(World world, BlockPos pos) {
        return BlockTags.field_200031_h.func_230235_a_((Object)world.func_180495_p(pos).func_177230_c());
    }

    public static final boolean isLeaf(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof LeavesBlock || BlockTags.field_206952_E.func_230235_a_((Object)block);
    }

    public void updateBreakBlock() {
        ++this.breakingTime;
        this.entity.func_184609_a(Hand.MAIN_HAND);
        int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
        if (this.breakingTime % 10 == 0) {
            this.entity.func_184185_a(SoundEvents.field_187889_gU, 1.0f, 1.0f);
            this.entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f);
        }
        if (i != this.previousBreakProgress) {
            this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), this.targetBlock, i);
            this.previousBreakProgress = i;
        }
        if (this.breakingTime == 160) {
            this.entity.func_184185_a(SoundEvents.field_187881_gQ, 1.0f, 1.0f);
            this.breakingTime = 0;
            this.previousBreakProgress = -1;
            this.fellTree();
            this.targetBlock = null;
            this.func_75251_c();
        }
    }

    private void resetTarget() {
        World world = this.entity.field_70170_p;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos workAreaCenter = this.entity.getWorkAreaCenter();
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        List searchBlocks = BlockPos.func_218281_b((BlockPos)workAreaCenter.func_177982_a(-workAreaSize, -workAreaSize / 2, -workAreaSize), (BlockPos)workAreaCenter.func_177982_a(workAreaSize, workAreaSize / 2, workAreaSize)).map(BlockPos::func_185334_h).collect(Collectors.toList());
        for (BlockPos pos : searchBlocks) {
            BlockPos logPos;
            if (!FellTreesGoal.isLog(world, pos)) continue;
            BlockPos topOfTree = new BlockPos((Vector3i)pos);
            while (!world.func_175623_d(topOfTree.func_177984_a()) && topOfTree.func_177956_o() < world.func_217301_I()) {
                topOfTree = topOfTree.func_177984_a();
            }
            if (!FellTreesGoal.isLeaf(world, topOfTree) || !FellTreesGoal.isLog(world, logPos = this.getStump(topOfTree))) continue;
            allBlocks.add(logPos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
            this.moveTarget = null;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                BlockPos pos = this.targetBlock.func_177972_a(facing);
                if (!this.entity.field_70170_p.func_175623_d(pos)) continue;
                this.moveTarget = pos;
                break;
            }
            if (this.moveTarget == null) {
                this.targetBlock = null;
            }
        }
    }

    private BlockPos getStump(BlockPos log) {
        if (log.func_177956_o() > 0) {
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)log.func_177982_a(-4, -4, -4), (BlockPos)log.func_177982_a(4, 0, 4)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                if (!FellTreesGoal.isLog(this.entity.field_70170_p, pos.func_177977_b()) && !FellTreesGoal.isLeaf(this.entity.field_70170_p, pos.func_177977_b())) continue;
                return this.getStump(pos.func_177977_b());
            }
        }
        return log;
    }

    private void fellTree() {
        World world = this.entity.field_70170_p;
        BlockPos base = new BlockPos((Vector3i)this.targetBlock);
        ArrayDeque<BlockPos> blocks = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        blocks.add(base);
        while (!blocks.isEmpty()) {
            BlockPos pos2;
            BlockPos pos = (BlockPos)blocks.remove();
            if (!visited.add(pos) || !FellTreesGoal.isLog(world, pos)) continue;
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                pos2 = pos.func_177972_a(facing);
                if (visited.contains(pos2)) continue;
                blocks.add(pos2);
            }
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    pos2 = pos.func_177982_a(-1 + x, 1, -1 + z);
                    if (visited.contains(pos2)) continue;
                    blocks.add(pos2);
                }
            }
            world.func_175655_b(pos, true);
        }
    }
}

