/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.spirit;

import com.github.klikli_dev.occultism.common.entity.spirit.AfritEntity;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class AfritWildEntity
extends AfritEntity {
    public AfritWildEntity(EntityType<? extends SpiritEntity> type, World world) {
        super(type, world);
        this.setSpiritMaxAge(36180);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int maxBlazes = 3 + world.func_201674_k().nextInt(6);
        for (int i = 0; i < maxBlazes; ++i) {
            BlazeEntity entity = (BlazeEntity)EntityType.field_200792_f.func_200721_a(this.field_70170_p);
            entity.func_213386_a(world, difficultyIn, reason, spawnDataIn, dataTag);
            double offsetX = (world.func_201674_k().nextGaussian() - 1.0) * (double)(1 + world.func_201674_k().nextInt(4));
            double offsetZ = (world.func_201674_k().nextGaussian() - 1.0) * (double)(1 + world.func_201674_k().nextInt(4));
            entity.func_70080_a(this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.5, this.func_226281_cx_() + offsetZ, (float)world.func_201674_k().nextInt(360), 0.0f);
            world.func_217376_c((Entity)entity);
        }
        return super.func_213386_a(world, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{BlazeEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_76347_k()) {
            return true;
        }
        ITag<EntityType<?>> alliesTags = OccultismTags.AFRIT_ALLIES;
        Entity trueSource = source.func_76346_g();
        if (trueSource != null && alliesTags.func_230235_a_((Object)trueSource.func_200600_R())) {
            return true;
        }
        Entity immediateSource = source.func_76364_f();
        if (immediateSource != null && alliesTags.func_230235_a_((Object)immediateSource.func_200600_R())) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return AfritEntity.registerAttributes();
    }
}

