/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.common.container.spirit.SpiritTransporterContainer;
import com.github.klikli_dev.occultism.common.entity.ai.DepositItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.ReturnToWorkAreaGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.github.klikli_dev.occultism.util.StorageUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;

public class CleanerJob
extends SpiritJob
implements INamedContainerProvider {
    protected PickupItemsGoal pickupItemsGoal;
    protected ReturnToWorkAreaGoal returnToWorkAreaGoal;
    protected DepositItemsGoal depositItemsGoal;

    public CleanerJob(SpiritEntity entity) {
        super(entity);
    }

    public ITextComponent func_145748_c_() {
        return this.entity.func_145748_c_();
    }

    @Override
    public void init() {
        this.returnToWorkAreaGoal = new ReturnToWorkAreaGoal(this.entity);
        this.entity.field_70715_bh.func_75776_a(0, (Goal)this.returnToWorkAreaGoal);
        this.pickupItemsGoal = new PickupItemsGoal(this.entity);
        this.entity.field_70715_bh.func_75776_a(1, (Goal)this.pickupItemsGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.field_70714_bg.func_75776_a(4, (Goal)this.depositItemsGoal);
    }

    @Override
    public void cleanup() {
        this.entity.field_70715_bh.func_85156_a((Goal)this.returnToWorkAreaGoal);
        this.entity.field_70715_bh.func_85156_a((Goal)this.pickupItemsGoal);
        this.entity.field_70714_bg.func_85156_a((Goal)this.depositItemsGoal);
    }

    @Override
    public boolean canPickupItem(ItemStack stack) {
        boolean matches = StorageUtil.matchesFilter(stack, (IItemHandler)this.entity.getFilterItems().orElseThrow(ItemHandlerMissingException::new)) || StorageUtil.matchesFilter(stack, this.entity.getTagFilter());
        boolean isBlacklist = this.entity.isFilterBlacklist();
        return !isBlacklist && matches || isBlacklist && !matches;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new SpiritTransporterContainer(id, playerInventory, this.entity);
    }
}

