/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.otherworld.IesniumOreNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldLeavesNaturalBlock;
import com.github.klikli_dev.occultism.common.world.multichunk.MultiChunkFeature;
import com.github.klikli_dev.occultism.common.world.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.config.OccultismCommonConfig;
import com.github.klikli_dev.occultism.registry.OccultismBiomeFeatures;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.util.StaticUtil;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.LeavesBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldGenHandler {
    public static ConfiguredFeature<?, ?> COPPER_ORE;
    public static ConfiguredFeature<?, ?> SILVER_ORE;
    public static ConfiguredFeature<?, ?> IESNIUM_ORE;
    public static ConfiguredFeature<?, ?> UNDERGROUND_GROVE;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> OTHERWORLD_TREE_NATURAL;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> OTHERWORLD_TREE;

    @SubscribeEvent
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (Occultism.COMMON_CONFIG.worldGen.oreGen.copperOre.generateOre.get()) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, COPPER_ORE);
        }
        if (Occultism.COMMON_CONFIG.worldGen.oreGen.silverOre.generateOre.get()) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, SILVER_ORE);
        }
        if (Occultism.COMMON_CONFIG.worldGen.oreGen.iesniumOre.generateOre.get()) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, IESNIUM_ORE);
        }
        if (Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.generateUndergroundGroves.get()) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, UNDERGROUND_GROVE);
        }
    }

    public static void registerConfiguredFeatures() {
        OccultismCommonConfig.WorldGenSettings.OreGenSettings oreGen = Occultism.COMMON_CONFIG.worldGen.oreGen;
        OccultismCommonConfig.WorldGenSettings.UndergroundGroveGenSettings groveGen = Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen;
        COPPER_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new TagMatchRuleTest(oreGen.copperOre.getFillerBlockTag()), ((Block)OccultismBlocks.COPPER_ORE.get()).func_176223_P(), oreGen.copperOre.size.get())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(oreGen.copperOre.bottomOffset.get(), oreGen.copperOre.topOffset.get(), oreGen.copperOre.maximum.get()))).func_242728_a()).func_242731_b(oreGen.copperOre.count.get());
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)StaticUtil.modLoc("copper_ore"), COPPER_ORE);
        SILVER_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new TagMatchRuleTest(oreGen.silverOre.getFillerBlockTag()), ((Block)OccultismBlocks.SILVER_ORE.get()).func_176223_P(), oreGen.silverOre.size.get())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(oreGen.silverOre.bottomOffset.get(), oreGen.silverOre.topOffset.get(), oreGen.silverOre.maximum.get()))).func_242728_a()).func_242731_b(oreGen.silverOre.count.get());
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)StaticUtil.modLoc("silver_ore"), SILVER_ORE);
        IESNIUM_ORE = (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new TagMatchRuleTest(oreGen.iesniumOre.getFillerBlockTag()), ((IesniumOreNaturalBlock)OccultismBlocks.IESNIUM_ORE_NATURAL.get()).func_176223_P(), oreGen.iesniumOre.size.get())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(oreGen.iesniumOre.bottomOffset.get(), oreGen.iesniumOre.topOffset.get(), oreGen.iesniumOre.maximum.get()))).func_242728_a()).func_242731_b(oreGen.iesniumOre.count.get());
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)StaticUtil.modLoc("iesnium_ore"), IESNIUM_ORE);
        UNDERGROUND_GROVE = ((MultiChunkFeature)OccultismBiomeFeatures.UNDERGROUND_GROVE_FEATURE.get()).func_225566_b_(new MultiChunkFeatureConfig(7, groveGen.groveSpawnChance.get(), groveGen.groveSpawnMin.get(), groveGen.groveSpawnMax.get(), 14653667, Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.biomeTypeBlacklist.get().stream().map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList()))).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig()));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)StaticUtil.modLoc("underground_grove"), UNDERGROUND_GROVE);
        OTHERWORLD_TREE_NATURAL = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OccultismBlocks.OTHERWORLD_LOG_NATURAL.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((OtherworldLeavesNaturalBlock)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)StaticUtil.modLoc("otherworld_tree_natural"), OTHERWORLD_TREE_NATURAL);
        OTHERWORLD_TREE = Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)OccultismBlocks.OTHERWORLD_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((LeavesBlock)OccultismBlocks.OTHERWORLD_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)StaticUtil.modLoc("otherworld"), OTHERWORLD_TREE);
    }
}

