/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.cave;

import com.github.klikli_dev.occultism.common.world.cave.CaveDecoratordata;
import com.github.klikli_dev.occultism.common.world.cave.ICaveDecorator;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;

public abstract class CaveDecorator
implements ICaveDecorator {
    public BlockState floorState;
    public BlockState ceilingState;
    public BlockState wallState;

    public CaveDecorator(BlockState floorState, BlockState ceilingState, BlockState wallState) {
        this.floorState = floorState;
        this.ceilingState = ceilingState;
        this.wallState = wallState;
    }

    @Override
    public void finalPass(ISeedReader seedReader, ChunkGenerator generator, Random rand, CaveDecoratordata data) {
        data.floorBlocks.forEach(blockPos -> this.finalFloorPass(seedReader, generator, rand, (BlockPos)blockPos));
        data.ceilingBlocks.forEach(blockPos -> this.finalCeilingPass(seedReader, generator, rand, (BlockPos)blockPos));
        data.wallBlocks.keySet().forEach(blockPos -> this.finalWallPass(seedReader, generator, rand, (BlockPos)blockPos));
        data.insideBlocks.forEach(blockPos -> this.finalInsidePass(seedReader, generator, rand, (BlockPos)blockPos));
    }

    @Override
    public void fill(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, CaveDecoratordata data) {
        BlockState state = seedReader.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)seedReader, pos) == -1.0f || seedReader.func_175710_j(pos)) {
            return;
        }
        if (this.isFloor(seedReader, pos, state)) {
            data.floorBlocks.add(pos);
            this.fillFloor(seedReader, generator, rand, pos, state);
        } else if (this.isCeiling(seedReader, pos, state)) {
            data.ceilingBlocks.add(pos);
            this.fillCeiling(seedReader, generator, rand, pos, state);
        } else if (this.isWall(seedReader, pos, state)) {
            data.wallBlocks.put(pos, this.getBorderDirection(seedReader, pos));
            this.fillWall(seedReader, generator, rand, pos, state);
        } else if (this.isInside(state)) {
            data.insideBlocks.add(pos);
            this.fillInside(seedReader, generator, rand, pos, state);
        }
    }

    public void fillFloor(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, BlockState state) {
        if (this.floorState != null) {
            seedReader.func_180501_a(pos, this.floorState, 2);
        }
    }

    public void fillCeiling(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, BlockState state) {
        if (this.ceilingState != null) {
            seedReader.func_180501_a(pos, this.ceilingState, 2);
        }
    }

    public void fillWall(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, BlockState state) {
        if (this.wallState != null) {
            seedReader.func_180501_a(pos, this.wallState, 2);
        }
    }

    public void fillInside(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, BlockState state) {
    }

    public void finalFloorPass(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
    }

    public void finalCeilingPass(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
    }

    public void finalWallPass(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
    }

    public void finalInsidePass(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
    }

    public boolean isFloor(ISeedReader seedReader, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)seedReader, pos)) {
            return false;
        }
        BlockPos upPos = pos.func_177984_a();
        return seedReader.func_175623_d(upPos) || seedReader.func_180495_p(upPos).func_185904_a().func_76222_j();
    }

    public boolean isCeiling(ISeedReader seedReader, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)seedReader, pos)) {
            return false;
        }
        BlockPos downPos = pos.func_177977_b();
        return seedReader.func_175623_d(downPos);
    }

    public boolean isWall(ISeedReader seedReader, BlockPos pos, BlockState state) {
        if (!state.func_200015_d((IBlockReader)seedReader, pos) || !this.isStone(state)) {
            return false;
        }
        return this.isBorder(seedReader, pos);
    }

    public Direction getBorderDirection(ISeedReader seedReader, BlockPos pos) {
        BlockState state = seedReader.func_180495_p(pos);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            BlockState stateAt = seedReader.func_180495_p(offsetPos);
            if ((state == stateAt || !seedReader.func_175623_d(offsetPos)) && !stateAt.func_185904_a().func_76222_j()) continue;
            return facing;
        }
        return null;
    }

    public boolean isBorder(ISeedReader seedReader, BlockPos pos) {
        return this.getBorderDirection(seedReader, pos) != null;
    }

    public boolean isInside(BlockState state) {
        return this.isStone(state);
    }

    public boolean isStone(BlockState state) {
        if (state != null) {
            return state.func_177230_c().func_203417_a(OccultismTags.CAVE_WALL_BLOCKS);
        }
        return false;
    }
}

