/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.cave;

import com.github.klikli_dev.occultism.common.world.cave.CaveDecoratordata;
import com.github.klikli_dev.occultism.common.world.cave.ICaveDecorator;
import com.github.klikli_dev.occultism.common.world.multichunk.IMultiChunkSubFeature;
import com.github.klikli_dev.occultism.common.world.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;

public class SphericalCaveSubFeature
implements IMultiChunkSubFeature {
    public static Set<BlockPos> sphericalCaves = new HashSet<BlockPos>();
    protected ICaveDecorator caveDecorator;
    protected int radius;
    protected int maxRandomRadiusOffset;
    protected int additionalSpheres;
    protected int maxRandomAdditionalSpheres;

    public SphericalCaveSubFeature(ICaveDecorator caveDecorator, int radius, int maxRandomRadiusOffset) {
        this(caveDecorator, radius, maxRandomRadiusOffset, 3, 2);
    }

    public SphericalCaveSubFeature(ICaveDecorator caveDecorator, int radius, int maxRandomRadiusOffset, int additionalSpheres, int maxRandomAdditionalSpheres) {
        this.caveDecorator = caveDecorator;
        this.radius = radius;
        this.maxRandomRadiusOffset = maxRandomRadiusOffset;
        this.additionalSpheres = additionalSpheres;
        this.maxRandomAdditionalSpheres = maxRandomAdditionalSpheres;
    }

    @Override
    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos rootPosition, AxisAlignedBB bounds, MultiChunkFeatureConfig config) {
        if (reader.func_175710_j(rootPosition)) {
            return false;
        }
        sphericalCaves.add(rootPosition);
        ChunkPos rootChunk = new ChunkPos(rootPosition);
        ((SharedSeedRandom)rand).func_202427_a(reader.func_72905_C(), rootChunk.field_77276_a, rootChunk.field_77275_b, config.featureSeedSalt);
        ArrayList<Sphere> spheres = new ArrayList<Sphere>();
        int radiusBase = this.radius + rand.nextInt(this.maxRandomRadiusOffset);
        int radius = (int)((float)radiusBase * 0.2f) + rand.nextInt(8);
        spheres.add(this.generateSphere((IWorld)reader, rand, rootPosition, radius, bounds));
        for (int i = 0; i < this.additionalSpheres + rand.nextInt(this.maxRandomAdditionalSpheres); ++i) {
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            spheres.add(this.generateSphere((IWorld)reader, rand, rootPosition.func_177967_a(direction, radius - 2), 2 * (int)((float)radius / 3.0f) + rand.nextInt(8), bounds));
        }
        for (Sphere sphere : spheres) {
            this.hollowOutSphere(reader, rand, sphere.center, sphere.radius - 2, bounds);
            this.decorateSphere(reader, generator, rand, sphere.center, sphere.radius + 2, bounds);
        }
        spheres.clear();
        return true;
    }

    protected Sphere generateSphere(IWorld world, Random rand, BlockPos position, int radius, AxisAlignedBB bounds) {
        return new Sphere(position, radius);
    }

    protected void hollowOutSphere(ISeedReader reader, Random rand, BlockPos center, int radius, AxisAlignedBB bounds) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos min = Math3DUtil.clamp(center.func_177982_a(-j, -k, -l), bounds);
        BlockPos max = Math3DUtil.clamp(center.func_177982_a(j, k, l), bounds);
        BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            BlockState currentState;
            if (blockPos.func_177951_i((Vector3i)center) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f)) && !(currentState = reader.func_180495_p(blockPos)).hasTileEntity() && currentState.func_177230_c() != Blocks.field_150357_h) {
                reader.func_180501_a(blockPos, Blocks.field_201941_jj.func_176223_P(), 2);
            }
        });
    }

    protected void decorateSphere(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos center, int radius, AxisAlignedBB bounds) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        CaveDecoratordata data = new CaveDecoratordata();
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos min = Math3DUtil.clamp(center.func_177982_a(-j, -k, -l), bounds);
        BlockPos max = Math3DUtil.clamp(center.func_177982_a(j, k, l), bounds);
        BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).forEach(blockPos -> {
            if (blockPos.func_177951_i((Vector3i)center) <= (double)(f * f)) {
                this.caveDecorator.fill(reader, generator, rand, blockPos.func_185334_h(), data);
            }
        });
        this.caveDecorator.finalPass(reader, generator, rand, data);
    }

    public class Sphere {
        public BlockPos center;
        public int radius;

        public Sphere(BlockPos center, int radius) {
            this.center = center;
            this.radius = radius;
        }
    }
}

