/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.world.cave;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.github.klikli_dev.occultism.common.world.WorldGenHandler;
import com.github.klikli_dev.occultism.common.world.cave.CaveDecorator;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class UndergroundGroveDecorator
extends CaveDecorator {
    public UndergroundGroveDecorator() {
        super(Blocks.field_196658_i.func_176223_P(), null, ((OtherstoneNaturalBlock)OccultismBlocks.OTHERSTONE_NATURAL.get()).func_176223_P());
    }

    @Override
    public void finalFloorPass(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
        if (seedReader.func_180495_p(pos).func_177230_c() == Blocks.field_196658_i && rand.nextFloat() < Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.grassChance.get()) {
            seedReader.func_180501_a(pos.func_177984_a(), Blocks.field_150349_c.func_176223_P(), 2);
        }
        if (rand.nextFloat() < Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.treeChance.get()) {
            ConfiguredFeature<BaseTreeFeatureConfig, ?> treeFeature = WorldGenHandler.OTHERWORLD_TREE_NATURAL;
            ((BaseTreeFeatureConfig)treeFeature.field_222738_b).func_227373_a_();
            treeFeature.func_242765_a(seedReader, generator, rand, pos.func_177984_a());
        }
    }

    @Override
    public void finalCeilingPass(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
        if (rand.nextFloat() < Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.ceilingLightChance.get()) {
            seedReader.func_180501_a(pos, Blocks.field_150426_aN.func_176223_P(), 2);
        }
        super.finalCeilingPass(seedReader, generator, rand, pos);
    }

    @Override
    public void finalWallPass(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.func_177972_a(facing);
            BlockPos up = offset.func_177984_a();
            if (!this.isCeiling(seedReader, up, seedReader.func_180495_p(up)) || !(rand.nextFloat() < Occultism.COMMON_CONFIG.worldGen.undergroundGroveGen.vineChance.get())) continue;
            BlockState stateAt = seedReader.func_180495_p(offset);
            boolean spawnedVine = false;
            while (stateAt.func_177230_c().isAir(stateAt, (IBlockReader)seedReader, offset) && offset.func_177956_o() > 0) {
                seedReader.func_180501_a(offset, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.func_176267_a((Direction)facing.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                offset = offset.func_177977_b();
                stateAt = seedReader.func_180495_p(offset);
                spawnedVine = true;
            }
            if (!spawnedVine) continue;
            return;
        }
    }
}

