/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.config;

import com.github.klikli_dev.occultism.config.ConfigBase;
import com.github.klikli_dev.occultism.config.ConfigCategoryBase;
import com.github.klikli_dev.occultism.config.IConfigCache;
import com.github.klikli_dev.occultism.config.value.CachedBoolean;
import com.github.klikli_dev.occultism.config.value.CachedFloat;
import com.github.klikli_dev.occultism.config.value.CachedInt;
import com.github.klikli_dev.occultism.config.value.CachedObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;

public class OccultismServerConfig
extends ConfigBase {
    public final StorageSettings storage;
    public final SpiritJobSettings spiritJobs;
    public final RitualSettings rituals;
    public final DimensionalMineshaftSettings dimensionalMineshaft;
    public final ItemSettings itemSettings;
    public final ForgeConfigSpec spec;

    public OccultismServerConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.storage = new StorageSettings(this, builder);
        this.spiritJobs = new SpiritJobSettings(this, builder);
        this.rituals = new RitualSettings(this, builder);
        this.dimensionalMineshaft = new DimensionalMineshaftSettings(this, builder);
        this.itemSettings = new ItemSettings(this, builder);
        this.spec = builder.build();
    }

    public class StorageSettings
    extends ConfigCategoryBase {
        public final CachedInt stabilizerTier1Slots;
        public final CachedInt stabilizerTier2Slots;
        public final CachedInt stabilizerTier3Slots;
        public final CachedInt stabilizerTier4Slots;
        public final CachedInt controllerBaseSlots;
        public final CachedInt controllerStackSize;
        public final CachedBoolean overrideItemStackSizes;

        public StorageSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Storage Settings").push("storage");
            this.stabilizerTier1Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 1 provides.").define("stabilizerTier1Slots", (Object)256));
            this.stabilizerTier2Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 2 provides.").define("stabilizerTier2Slots", (Object)512));
            this.stabilizerTier3Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 3 provides.").define("stabilizerTier3Slots", (Object)1024));
            this.stabilizerTier4Slots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage stabilizer tier 4 provides.").define("stabilizerTier4Slots", (Object)2048));
            this.controllerBaseSlots = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of slots the storage actuator provides.").define("controllerBaseSlots", (Object)128));
            this.controllerStackSize = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The stack size the storage actuator uses.").define("controllerStackSize", (Object)1024));
            this.overrideItemStackSizes = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("True to use the configured controllerStackSize for all items, instead of the stack sizes provided by item type (such as 16 for ender pearls, 64 for iron ingot). WARNING: Setting this to false may have a negative impact on performance.").define("overrideItemStackSizes", true));
            builder.pop();
        }
    }

    public class RitualSettings
    extends ConfigCategoryBase {
        public final CachedBoolean enableClearWeatherRitual;
        public final CachedBoolean enableRainWeatherRitual;
        public final CachedBoolean enableThunderWeatherRitual;
        public final CachedBoolean enableDayTimeRitual;
        public final CachedBoolean enableNightTimeRitual;
        public final CachedBoolean enableRemainingIngredientCountMatching;

        public RitualSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Ritual Settings").push("rituals");
            this.enableClearWeatherRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to clear rainy weather.").define("enableClearWeatherRitual", true));
            this.enableRainWeatherRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to start rainy weather.").define("enableRainWeatherRitual", true));
            this.enableThunderWeatherRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to start a thunderstorm.").define("enableThunderWeatherRitual", true));
            this.enableDayTimeRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to set time to day.").define("enableDayTimeRitual", true));
            this.enableNightTimeRitual = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("Enables the ritual to set time to night.").define("enableNightTimeRitual", true));
            this.enableRemainingIngredientCountMatching = CachedBoolean.cache(this, (ForgeConfigSpec.ConfigValue<Boolean>)builder.comment("If enabled, rituals are interrupted if *more* ingredients are present than needed. This should usually be disabled, but can improve performance if (very very) many rituals are running.").define("enableRemainingIngredientCountMatching", false));
            builder.pop();
        }
    }

    public class DimensionalMineshaftSettings
    extends ConfigCategoryBase {
        public final MinerSpiritSettings minerFoliotUnspecialized;
        public final MinerSpiritSettings minerDjinniOres;

        public DimensionalMineshaftSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Dimensional Mineshaft Settings").push("dimensional_mineshaft");
            this.minerFoliotUnspecialized = new MinerSpiritSettings("miner_foliot_unspecialized", parent, builder, 400, 1, 1000);
            this.minerDjinniOres = new MinerSpiritSettings("miner_djinni_ores", parent, builder, 400, 1, 100);
            builder.pop();
        }

        public class MinerSpiritSettings
        extends ConfigCategoryBase {
            public final CachedInt maxMiningTime;
            public final CachedInt rollsPerOperation;
            public final CachedInt durability;

            public MinerSpiritSettings(String oreName, IConfigCache parent, ForgeConfigSpec.Builder builder, int maxMiningTime, int rollsPerOperation, int durability) {
                super(parent, builder);
                builder.comment("Miner Spirit Settings").push(oreName);
                this.maxMiningTime = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of time it takes the spirit to perform one mining operation.").define("maxMiningTime", (Object)maxMiningTime));
                this.rollsPerOperation = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of blocks the spirit will obtain per mining operation").define("rollsPerOperation", (Object)rollsPerOperation));
                this.durability = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The amount of mining operations the spirit can perform before breaking.").define("durability", (Object)durability));
                builder.pop();
            }
        }
    }

    public class SpiritJobSettings
    extends ConfigCategoryBase {
        public final CachedFloat tier1CrusherTimeMultiplier;
        public final CachedFloat tier2CrusherTimeMultiplier;
        public final CachedFloat tier3CrusherTimeMultiplier;
        public final CachedFloat tier4CrusherTimeMultiplier;
        public final CachedFloat tier1CrusherOutputMultiplier;
        public final CachedFloat tier2CrusherOutputMultiplier;
        public final CachedFloat tier3CrusherOutputMultiplier;
        public final CachedFloat tier4CrusherOutputMultiplier;
        public final CachedInt drikwingFamiliarSlowFallingSeconds;
        public final CachedInt tier1CrusherMaxAgeSeconds;
        public final CachedInt tier2CrusherMaxAgeSeconds;
        public final CachedInt tier3CrusherMaxAgeSeconds;
        public final CachedInt tier4CrusherMaxAgeSeconds;
        public final CachedInt tier1SaplingTraderMaxAgeSeconds;
        public final CachedInt tier1OtherstoneTraderMaxAgeSeconds;

        public SpiritJobSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Spirit Job Settings").push("spirit_job");
            this.drikwingFamiliarSlowFallingSeconds = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The duration for the slow falling effect applied by a drikwing.").define("drikwingFamiliarSlowFallingSeconds", (Object)15));
            this.tier1CrusherTimeMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 1 (Foliot) Crusher Spirits.").define("tier1CrusherTimeMultiplier", (Object)2.0));
            this.tier2CrusherTimeMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The multiplier to each crushing recipe's crushing_time for Tier 2 (Djinni) Crusher Spirits.").define("tier2CrusherTimeMultiplier", (Object)1.0));
            this.tier3CrusherTimeMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 3 (Afrit) Crusher Spirits.").define("tier3CrusherTimeMultiplier", (Object)0.5));
            this.tier4CrusherTimeMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("Currently unused. The multiplier to each crushing recipe's crushing_time for Tier 4 (Marid) Crusher Spirits.").define("tier4CrusherTimeMultiplier", (Object)0.2));
            this.tier1CrusherOutputMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The multiplier to each crushing recipe's output count for Tier 1 (Foliot) Crusher Spirits.").define("tier1CrusherOutputMultiplier", (Object)1.0));
            this.tier2CrusherOutputMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The multiplier to each crushing recipe's output count for Tier 2 (Djinni) Crusher Spirits.").define("tier2CrusherOutputMultiplier", (Object)1.5));
            this.tier3CrusherOutputMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The multiplier to each crushing recipe's output count for Tier 3 (Afrit) Crusher Spirits.").define("tier3CrusherOutputMultiplier", (Object)2.0));
            this.tier4CrusherOutputMultiplier = CachedFloat.cache(this, (ForgeConfigSpec.ConfigValue<Double>)builder.comment("The multiplier to each crushing recipe's output count for Tier 4 (Marid) Crusher Spirits.").define("tier4CrusherOutputMultiplier", (Object)3.0));
            this.tier1CrusherMaxAgeSeconds = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max seconds before a spirit despawns. -1 to disable despawn.").define("tier1CrusherMaxAgeSeconds", (Object)32400));
            this.tier2CrusherMaxAgeSeconds = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max seconds before a spirit despawns. -1 to disable despawn.").define("tier2CrusherMaxAgeSeconds", (Object)-1));
            this.tier3CrusherMaxAgeSeconds = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max seconds before a spirit despawns. -1 to disable despawn.").define("tier3CrusherMaxAgeSeconds", (Object)-1));
            this.tier4CrusherMaxAgeSeconds = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max seconds before a spirit despawns. -1 to disable despawn.").define("tier4CrusherMaxAgeSeconds", (Object)-1));
            this.tier1SaplingTraderMaxAgeSeconds = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max seconds before a spirit despawns. -1 to disable despawn.").define("tier1SaplingTraderMaxAgeSeconds", (Object)3600));
            this.tier1OtherstoneTraderMaxAgeSeconds = CachedInt.cache(this, (ForgeConfigSpec.ConfigValue<Integer>)builder.comment("The max seconds before a spirit despawns. -1 to disable despawn.").define("tier1SaplingTraderMaxAgeSeconds", (Object)3600));
            builder.pop();
        }
    }

    public class ItemSettings
    extends ConfigCategoryBase {
        public final CachedObject<List<String>> soulgemEntityTypeDenyList;

        public ItemSettings(IConfigCache parent, ForgeConfigSpec.Builder builder) {
            super(parent, builder);
            builder.comment("Item Settings").push("items");
            List defaultSoulgemEntityDenyList = Stream.of("minecraft:wither").collect(Collectors.toList());
            this.soulgemEntityTypeDenyList = CachedObject.cache(this, builder.comment("Entity types that cannot be captured in a soul gem. Specify by their full id, e.g \"minecraft:zombie\"").define("soulgemEntityDenyList", defaultSoulgemEntityDenyList));
            builder.pop();
        }
    }
}

