/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventory;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;

public abstract class ItemStackFakeInventoryRecipe
implements IRecipe<ItemStackFakeInventory> {
    public static Serializer SERIALIZER = new Serializer();
    protected final ResourceLocation id;
    protected final Ingredient input;
    protected final ItemStack output;

    public ItemStackFakeInventoryRecipe(ResourceLocation id, Ingredient input, ItemStack output) {
        this.input = input;
        this.output = output;
        this.id = id;
    }

    public boolean matches(ItemStackFakeInventory inv, World world) {
        return this.input.test(inv.func_70301_a(0));
    }

    public ItemStack getCraftingResult(ItemStackFakeInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer {
        public <T extends ItemStackFakeInventoryRecipe> T read(IItemStackFakeInventoryRecipeFactory<T> factory, ResourceLocation recipeId, JsonObject json) {
            JsonArray ingredientElement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientElement);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return factory.create(recipeId, ingredient, result);
        }

        public <T extends ItemStackFakeInventoryRecipe> T read(IItemStackFakeInventoryRecipeFactory<T> factory, ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            return factory.create(recipeId, ingredient, result);
        }

        public <T extends ItemStackFakeInventoryRecipe> void write(PacketBuffer buffer, T recipe) {
            recipe.input.func_199564_a(buffer);
            buffer.func_150788_a(recipe.output);
        }
    }

    public static interface IItemStackFakeInventoryRecipeFactory<T extends ItemStackFakeInventoryRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, ItemStack var3);
    }
}

