/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RitualRecipe
extends ShapelessRecipe {
    public static Serializer SERIALIZER = new Serializer();
    private ResourceLocation pentacleId;
    private ItemStack ritual;
    private Ingredient activationItem;
    private boolean requireSacrifice;
    private boolean requireItemUse;

    public RitualRecipe(ResourceLocation id, String group, ResourceLocation pentacleId, ItemStack ritual, ItemStack result, Ingredient activationItem, NonNullList<Ingredient> input, boolean requireSacrifice, boolean requireItemUse) {
        super(id, group, result, input);
        this.pentacleId = pentacleId;
        this.ritual = ritual;
        this.activationItem = activationItem;
        this.requireSacrifice = requireSacrifice;
        this.requireItemUse = requireItemUse;
    }

    public ResourceLocation getPentacleId() {
        return this.pentacleId;
    }

    public ItemStack getRitual() {
        return this.ritual;
    }

    public Ingredient getActivationItem() {
        return this.activationItem;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inventory, @Nonnull World world) {
        return false;
    }

    public ItemStack func_77572_b(CraftingInventory inventoryCrafting) {
        return null;
    }

    public IRecipeType<?> func_222127_g() {
        return (IRecipeType)OccultismRecipes.RITUAL_TYPE.get();
    }

    public boolean requireSacrifice() {
        return this.requireSacrifice;
    }

    public boolean requireItemUse() {
        return this.requireItemUse;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RitualRecipe> {
        private static final ShapelessRecipe.Serializer serializer = new ShapelessRecipe.Serializer();

        public RitualRecipe read(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe recipe = serializer.func_199425_a_(recipeId, json);
            JsonArray activationItemElement = JSONUtils.func_151202_d((JsonObject)json, (String)"activation_item") ? JSONUtils.func_151214_t((JsonObject)json, (String)"activation_item") : JSONUtils.func_152754_s((JsonObject)json, (String)"activation_item");
            Ingredient activationItem = Ingredient.func_199802_a((JsonElement)activationItemElement);
            ResourceLocation pentacleId = new ResourceLocation(json.get("pentacle_id").getAsString());
            ItemStack ritual = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"ritual"), (boolean)true);
            boolean requireSacrifice = json.get("require_sacrifice").getAsBoolean();
            boolean requireItemUse = json.get("require_item_use").getAsBoolean();
            return new RitualRecipe(recipe.func_199560_c(), recipe.func_193358_e(), pentacleId, ritual, recipe.func_77571_b(), activationItem, (NonNullList<Ingredient>)recipe.func_192400_c(), requireSacrifice, requireItemUse);
        }

        public RitualRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ShapelessRecipe recipe = serializer.func_199426_a_(recipeId, buffer);
            ResourceLocation pentacleId = buffer.func_192575_l();
            ItemStack ritual = buffer.func_150791_c();
            Ingredient activationItem = Ingredient.func_199566_b((PacketBuffer)buffer);
            boolean requireSacrifice = buffer.readBoolean();
            boolean requireItemUse = buffer.readBoolean();
            return new RitualRecipe(recipe.func_199560_c(), recipe.func_193358_e(), pentacleId, ritual, recipe.func_77571_b(), activationItem, (NonNullList<Ingredient>)recipe.func_192400_c(), requireSacrifice, requireItemUse);
        }

        public void write(PacketBuffer buffer, RitualRecipe recipe) {
            serializer.func_199427_a_(buffer, (ShapelessRecipe)recipe);
            buffer.func_192572_a(recipe.pentacleId);
            buffer.func_150788_a(recipe.ritual);
            recipe.activationItem.func_199564_a(buffer);
            buffer.writeBoolean(recipe.requireSacrifice);
            buffer.writeBoolean(recipe.requireItemUse);
        }
    }
}

