/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei;

import com.github.klikli_dev.occultism.network.MessageSetRecipe;
import com.github.klikli_dev.occultism.network.MessageSetRecipeByID;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class StorageControllerRecipeTransferHandler<T extends Container>
implements IRecipeTransferHandler<T> {
    protected final Class<T> containerClass;
    protected final IRecipeTransferHandlerHelper helper;

    public StorageControllerRecipeTransferHandler(Class<T> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, Object recipeObject, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        IRecipe recipe = (IRecipe)recipeObject;
        if (recipe.func_199560_c() == null) {
            return this.helper.createUserErrorWithTooltip(I18n.func_135052_a((String)"jei.occultismerror.missing_id", (Object[])new Object[0]));
        }
        if (!recipe.func_194133_a(3, 3)) {
            return this.helper.createUserErrorWithTooltip(I18n.func_135052_a((String)"jei.occultismerror.recipe_too_large", (Object[])new Object[0]));
        }
        if (player.func_130014_f_().func_199532_z().func_215367_a(recipe.func_199560_c()).isPresent()) {
            OccultismPackets.sendToServer(new MessageSetRecipeByID(recipe.func_199560_c()));
        } else {
            OccultismPackets.sendToServer(new MessageSetRecipe(this.recipeToTag((Container)container, recipeLayout)));
        }
        return null;
    }

    public CompoundNBT recipeToTag(Container container, IRecipeLayout recipeLayout) {
        CompoundNBT nbt = new CompoundNBT();
        Map inputs = recipeLayout.getItemStacks().getGuiIngredients();
        for (Slot slot : container.field_75151_b) {
            List possibleItems;
            IGuiIngredient ingredient;
            if (!(slot.field_75224_c instanceof CraftingInventory) || (ingredient = (IGuiIngredient)inputs.get(slot.getSlotIndex() + 1)) == null || (possibleItems = ingredient.getAllIngredients()).isEmpty()) continue;
            ListNBT invList = new ListNBT();
            for (int i = 0; i < possibleItems.size() && i < 5; ++i) {
                ItemStack itemStack = (ItemStack)possibleItems.get(i);
                if (itemStack.func_190926_b()) continue;
                invList.add((Object)itemStack.serializeNBT());
            }
            nbt.func_218657_a("s" + slot.getSlotIndex(), (INBT)invList);
        }
        return nbt;
    }
}

