/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSetWorkAreaSize
extends MessageBase {
    public int workAreaSize;

    public MessageSetWorkAreaSize(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageSetWorkAreaSize(int workAreaSize) {
        this.workAreaSize = workAreaSize;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        ItemStack stack = player.func_184586_b(Hand.MAIN_HAND);
        if (stack.func_77973_b() instanceof BookOfCallingItem) {
            ItemNBTUtil.getSpiritEntity(stack).ifPresent(spirit -> {
                WorkAreaSize workAreaSize = WorkAreaSize.get(this.workAreaSize);
                spirit.setWorkAreaSize(workAreaSize);
                ItemNBTUtil.updateItemNBTFromEntity(stack, spirit);
                player.field_71069_bz.func_75142_b();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.occultism.book_of_calling.message_set_work_area_size", new Object[]{TextUtil.formatDemonName((IFormattableTextComponent)spirit.func_200200_C_()), new TranslationTextComponent(workAreaSize.getTranslationKey())}), true);
            });
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.workAreaSize);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.workAreaSize = buf.readInt();
    }
}

