/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageToggleFamiliarSettings
extends MessageBase {
    public boolean toggleOtherworldBird;
    public boolean toggleGreedy;

    public MessageToggleFamiliarSettings(PacketBuffer buf) {
        this.decode(buf);
    }

    public MessageToggleFamiliarSettings(boolean toggleOtherworldBird, boolean toggleGreedy) {
        this.toggleOtherworldBird = toggleOtherworldBird;
        this.toggleGreedy = toggleGreedy;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayerEntity player, NetworkEvent.Context context) {
        player.getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).ifPresent(cap -> {
            if (this.toggleGreedy) {
                cap.setGreedyEnabled(!cap.isGreedyEnabled());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.occultism.familiar.greedy." + (cap.isGreedyEnabled() ? "enabled" : "disabled")), true);
            }
            if (this.toggleOtherworldBird) {
                cap.setOtherworldBirdEnabled(!cap.isOtherworldBirdEnabled());
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.occultism.familiar.otherworld_bird." + (cap.isOtherworldBirdEnabled() ? "enabled" : "disabled")), true);
            }
        });
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.toggleOtherworldBird);
        buf.writeBoolean(this.toggleGreedy);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.toggleOtherworldBird = buf.readBoolean();
        this.toggleGreedy = buf.readBoolean();
    }
}

