/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.common.item.armor.OtherworldGogglesItem;
import com.github.klikli_dev.occultism.common.item.storage.SatchelItem;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtil {
    public static boolean hasGoggles(PlayerEntity player) {
        ItemStack helmet = player.func_184582_a(EquipmentSlotType.HEAD);
        if (helmet.func_77973_b() instanceof OtherworldGogglesItem) {
            return true;
        }
        Optional hasGoggles = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> {
            Optional<Boolean> hasGogglesStack = curiosHandler.getStacksHandler(SlotTypePreset.HEAD.getIdentifier()).map(slotHandler -> {
                IDynamicStackHandler stackHandler = slotHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof OtherworldGogglesItem)) continue;
                    return true;
                }
                return false;
            });
            return hasGogglesStack.orElse(false);
        });
        return hasGoggles.orElse(false);
    }

    public static ItemStack getBackpack(PlayerEntity player) {
        Optional hasBackpack = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> {
            Optional<ItemStack> hasBackpackStack = curiosHandler.getStacksHandler(SlotTypePreset.BELT.getIdentifier()).map(slotHandler -> {
                IDynamicStackHandler stackHandler = slotHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof SatchelItem)) continue;
                    return stack;
                }
                return ItemStack.field_190927_a;
            });
            return hasBackpackStack.orElse(ItemStack.field_190927_a);
        });
        return hasBackpack.orElse(ItemStack.field_190927_a);
    }

    public static int getFirstBackpackSlot(PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (!(stack.func_77973_b() instanceof SatchelItem)) continue;
            return slot;
        }
        return -1;
    }
}

