/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.common.events;

import com.sammy.omnis.OmnisHelper;
import com.sammy.omnis.common.items.equipment.armor.HauntedSteelArmorItem;
import com.sammy.omnis.common.items.gear.ModBroadswordItem;
import com.sammy.omnis.common.items.gear.ModGreataxeItem;
import com.sammy.omnis.common.items.gear.ModHammerItem;
import com.sammy.omnis.common.items.loot.CurioEvokerCharm;
import com.sammy.omnis.common.items.loot.SpellBladeItem;
import com.sammy.omnis.common.items.loot.VindicatorAxeItem;
import com.sammy.omnis.core.init.OmnisItems;
import com.sammy.omnis.core.init.effects.OmnisEffects;
import com.sammy.omnis.network.NetworkManager;
import com.sammy.omnis.network.packets.ParticlePacket;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber
public class RuntimeEvents {
    @SubscribeEvent
    public static void triggerOnHitEffects(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            EffectInstance effectInstance;
            PlayerEntity attacker = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            ItemStack heldStack = attacker.func_184614_ca();
            Item heldItem = heldStack.func_77973_b();
            if (target.func_110138_aP() == target.func_110143_aJ()) {
                boolean success = false;
                if (heldItem instanceof ModHammerItem) {
                    target.func_195064_c(new EffectInstance((Effect)OmnisEffects.STAGGERED.get(), 200, ((ModHammerItem)heldItem).staggeredAmplifier));
                    success = true;
                }
                if (heldItem instanceof ModGreataxeItem) {
                    target.func_195064_c(new EffectInstance((Effect)OmnisEffects.STUNNED.get(), 200, ((ModGreataxeItem)heldItem).stunnedAmplifier));
                    success = true;
                }
                if (heldItem instanceof ModBroadswordItem && !attacker.func_184811_cZ().func_185141_a(heldItem)) {
                    attacker.func_184811_cZ().func_185145_a(heldItem, 4);
                    target.field_70172_ad = 0;
                    target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), ((ModBroadswordItem)heldItem).extraDamage);
                    success = true;
                }
                if (success) {
                    target.field_70170_p.func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187825_fO, SoundCategory.PLAYERS, 1.0f, 1.8f);
                    target.field_70170_p.func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 0.8f);
                    target.field_70170_p.func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    target.field_70170_p.func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 1.2f);
                    attacker.func_71009_b((Entity)target);
                }
            }
            if (heldItem instanceof VindicatorAxeItem && (target.func_70668_bt().equals(CreatureAttribute.field_223225_d_) || target instanceof PlayerEntity || target instanceof AbstractVillagerEntity || target instanceof ZombieVillagerEntity)) {
                VindicatorAxeItem vindicatorAxeItem = (VindicatorAxeItem)heldItem;
                if (!attacker.func_184811_cZ().func_185141_a(heldItem)) {
                    event.setAmount(event.getAmount() + 8.0f);
                    if (attacker.field_70170_p instanceof ServerWorld) {
                        NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> target), (Object)new ParticlePacket(ParticlePacket.typeEnum.vindicatorAxe, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_()));
                    }
                    attacker.func_184811_cZ().func_185145_a(vindicatorAxeItem.getItem(), vindicatorAxeItem.effectCooldown);
                }
            }
            if (heldItem instanceof SpellBladeItem && !event.getSource().func_82725_o()) {
                SpellBladeItem spellBladeItem = (SpellBladeItem)heldItem;
                float amount = event.getAmount() * spellBladeItem.effectStrength;
                event.setAmount(event.getAmount() - amount);
                event.getEntity().field_70172_ad = 0;
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker).func_82726_p(), amount);
                if (attacker.field_70170_p instanceof ServerWorld) {
                    NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> target), (Object)new ParticlePacket(ParticlePacket.typeEnum.spellBlade, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() / 2.0f), target.func_226281_cx_()));
                }
            }
            if (event.getSource().func_82725_o()) {
                float resistance = 1.0f;
                for (ItemStack stack : target.func_184193_aE()) {
                    if (!(stack.func_77973_b() instanceof HauntedSteelArmorItem)) continue;
                    resistance -= 0.125f;
                }
                event.setAmount(event.getAmount() * resistance);
            }
            if (CuriosApi.getCuriosHelper().findEquippedCurio(s -> s.func_77973_b() instanceof CurioEvokerCharm, (LivingEntity)attacker).isPresent() && event.getSource().func_82725_o()) {
                event.setAmount(event.getAmount() + 4.0f);
            }
            if ((effectInstance = attacker.func_70660_b((Effect)OmnisEffects.MAGIC_PROFICIENCY.get())) != null && event.getSource().func_82725_o()) {
                event.setAmount(event.getAmount() + (float)(4 * (effectInstance.func_76458_c() + 1)));
            }
        }
    }

    @SubscribeEvent
    public static void giveEnemiesSpecialWeapons(EntityJoinWorldEvent event) {
        if (OmnisHelper.areWeOnServer(event.getWorld())) {
            if (event.getEntity() instanceof VexEntity) {
                VexEntity vexEntity = (VexEntity)event.getEntity();
                vexEntity.func_184201_a(EquipmentSlotType.MAINHAND, ((Item)OmnisItems.SPELL_BLADE.get()).func_190903_i());
                vexEntity.func_184642_a(EquipmentSlotType.MAINHAND, 0.8f);
            }
            if (event.getEntity() instanceof VindicatorEntity) {
                VindicatorEntity vindicatorEntity = (VindicatorEntity)event.getEntity();
                vindicatorEntity.func_184201_a(EquipmentSlotType.MAINHAND, ((Item)OmnisItems.VINDICATOR_AXE.get()).func_190903_i());
                vindicatorEntity.func_184642_a(EquipmentSlotType.MAINHAND, 0.8f);
                vindicatorEntity.func_213395_q(true);
            }
        }
    }
}

